/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.MismatchListener;
import org.apache.cassandra.fqltool.ResultComparator;
import org.apache.cassandra.fqltool.ResultStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultHandler
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ResultHandler.class);
    private final ResultStore resultStore;
    private final ResultComparator resultComparator;
    private final List<String> targetHosts;

    public ResultHandler(List<String> targetHosts, List<File> resultPaths, File queryFilePath) {
        this(targetHosts, resultPaths, queryFilePath, null);
    }

    public ResultHandler(List<String> targetHosts, List<File> resultPaths, File queryFilePath, MismatchListener mismatchListener) {
        this.targetHosts = targetHosts;
        this.resultStore = resultPaths != null ? new ResultStore(resultPaths, queryFilePath) : null;
        this.resultComparator = new ResultComparator(mismatchListener);
    }

    public void handleResults(FQLQuery query, List<ComparableResultSet> results) {
        List<ComparableRow> rows;
        for (int i = 0; i < this.targetHosts.size(); ++i) {
            if (!results.get(i).wasFailed()) continue;
            logger.error("Query {} against {} failure: {}", new Object[]{query, this.targetHosts.get(i), results.get(i).getFailureException().getMessage()});
        }
        List<ComparableColumnDefinitions> columnDefinitions = results.stream().map(ComparableResultSet::getColumnDefinitions).collect(Collectors.toList());
        this.resultComparator.compareColumnDefinitions(this.targetHosts, query, columnDefinitions);
        if (this.resultStore != null) {
            this.resultStore.storeColumnDefinitions(query, columnDefinitions);
        }
        List<Iterator<ComparableRow>> iters = results.stream().map(Iterable::iterator).collect(Collectors.toList());
        do {
            rows = ResultHandler.rows(iters);
            this.resultComparator.compareRows(this.targetHosts, query, rows);
            if (this.resultStore == null) continue;
            this.resultStore.storeRows(rows);
        } while (!rows.stream().allMatch(Objects::isNull));
    }

    @VisibleForTesting
    public static List<ComparableRow> rows(List<Iterator<ComparableRow>> iters) {
        ArrayList<ComparableRow> rows = new ArrayList<ComparableRow>(iters.size());
        for (Iterator<ComparableRow> iter : iters) {
            if (iter.hasNext()) {
                rows.add(iter.next());
                continue;
            }
            rows.add(null);
        }
        return rows;
    }

    @Override
    public void close() throws IOException {
        if (this.resultStore != null) {
            this.resultStore.close();
        }
    }

    public static interface ComparableRow {
        public ByteBuffer getBytesUnsafe(int var1);

        public ComparableColumnDefinitions getColumnDefinitions();
    }

    public static interface ComparableDefinition {
        public String getType();

        public String getName();
    }

    public static interface ComparableColumnDefinitions
    extends Iterable<ComparableDefinition> {
        public List<ComparableDefinition> asList();

        public boolean wasFailed();

        public Throwable getFailureException();

        public int size();
    }

    public static interface ComparableResultSet
    extends Iterable<ComparableRow> {
        public ComparableColumnDefinitions getColumnDefinitions();

        public boolean wasFailed();

        public Throwable getFailureException();
    }
}

