/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CapabilityApplyConfiguration represents an declarative configuration of the Capability type for use
// with apply.
type CapabilityApplyConfiguration struct {
	Dependencies        []MavenArtifactApplyConfiguration `json:"dependencies,omitempty"`
	RuntimeProperties   []CamelPropertyApplyConfiguration `json:"runtimeProperties,omitempty"`
	BuildTimeProperties []CamelPropertyApplyConfiguration `json:"buildTimeProperties,omitempty"`
	Metadata            map[string]string                 `json:"metadata,omitempty"`
}

// CapabilityApplyConfiguration constructs an declarative configuration of the Capability type for use with
// apply.
func Capability() *CapabilityApplyConfiguration {
	return &CapabilityApplyConfiguration{}
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *CapabilityApplyConfiguration) WithDependencies(values ...*MavenArtifactApplyConfiguration) *CapabilityApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDependencies")
		}
		b.Dependencies = append(b.Dependencies, *values[i])
	}
	return b
}

// WithRuntimeProperties adds the given value to the RuntimeProperties field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RuntimeProperties field.
func (b *CapabilityApplyConfiguration) WithRuntimeProperties(values ...*CamelPropertyApplyConfiguration) *CapabilityApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRuntimeProperties")
		}
		b.RuntimeProperties = append(b.RuntimeProperties, *values[i])
	}
	return b
}

// WithBuildTimeProperties adds the given value to the BuildTimeProperties field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BuildTimeProperties field.
func (b *CapabilityApplyConfiguration) WithBuildTimeProperties(values ...*CamelPropertyApplyConfiguration) *CapabilityApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithBuildTimeProperties")
		}
		b.BuildTimeProperties = append(b.BuildTimeProperties, *values[i])
	}
	return b
}

// WithMetadata puts the entries into the Metadata field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Metadata field,
// overwriting an existing map entries in Metadata field with the same key.
func (b *CapabilityApplyConfiguration) WithMetadata(entries map[string]string) *CapabilityApplyConfiguration {
	if b.Metadata == nil && len(entries) > 0 {
		b.Metadata = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Metadata[k] = v
	}
	return b
}
