/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Interact with Google Cloud Vertex AI generative models.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GoogleVertexAIEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Google Vertex AI component.
     */
    public interface GoogleVertexAIEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedGoogleVertexAIEndpointBuilder advanced() {
            return (AdvancedGoogleVertexAIEndpointBuilder) this;
        }

        /**
         * The Service account key that can be used as credentials for the
         * Vertex AI client. It can be loaded by default from classpath, but you
         * can prefix with classpath:, file:, or http: to load the resource from
         * different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceAccountKey the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder serviceAccountKey(String serviceAccountKey) {
            doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
        /**
         * Anthropic API version for Claude models. Required when publisher is
         * 'anthropic'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: vertex-2023-10-16
         * Group: producer
         * 
         * @param anthropicVersion the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder anthropicVersion(String anthropicVersion) {
            doSetProperty("anthropicVersion", anthropicVersion);
            return this;
        }
        /**
         * Number of candidate responses to generate.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param candidateCount the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder candidateCount(Integer candidateCount) {
            doSetProperty("candidateCount", candidateCount);
            return this;
        }
        /**
         * Number of candidate responses to generate.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param candidateCount the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder candidateCount(String candidateCount) {
            doSetProperty("candidateCount", candidateCount);
            return this;
        }
        /**
         * Whether to use JSON request/response format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param jsonMode the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder jsonMode(boolean jsonMode) {
            doSetProperty("jsonMode", jsonMode);
            return this;
        }
        /**
         * Whether to use JSON request/response format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param jsonMode the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder jsonMode(String jsonMode) {
            doSetProperty("jsonMode", jsonMode);
            return this;
        }
        /**
         * Maximum number of output tokens.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1024
         * Group: producer
         * 
         * @param maxOutputTokens the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder maxOutputTokens(Integer maxOutputTokens) {
            doSetProperty("maxOutputTokens", maxOutputTokens);
            return this;
        }
        /**
         * Maximum number of output tokens.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 1024
         * Group: producer
         * 
         * @param maxOutputTokens the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder maxOutputTokens(String maxOutputTokens) {
            doSetProperty("maxOutputTokens", maxOutputTokens);
            return this;
        }
        /**
         * Set the operation for the producer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.vertexai.GoogleVertexAIOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder operation(org.apache.camel.component.google.vertexai.GoogleVertexAIOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the operation for the producer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.google.vertexai.GoogleVertexAIOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Publisher name for partner models (e.g., anthropic, meta, mistralai).
         * Required for rawPredict operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param publisher the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder publisher(String publisher) {
            doSetProperty("publisher", publisher);
            return this;
        }
        /**
         * Streaming output mode: complete (default) or chunks.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: complete
         * Group: producer
         * 
         * @param streamOutputMode the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder streamOutputMode(String streamOutputMode) {
            doSetProperty("streamOutputMode", streamOutputMode);
            return this;
        }
        /**
         * Temperature parameter for generation (0.0-1.0).
         * 
         * The option is a: <code>java.lang.Float</code> type.
         * 
         * Default: 0.7
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder temperature(Float temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Temperature parameter for generation (0.0-1.0).
         * 
         * The option will be converted to a <code>java.lang.Float</code> type.
         * 
         * Default: 0.7
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder temperature(String temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Top-K parameter for generation.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 40
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder topK(Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Top-K parameter for generation.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 40
         * Group: producer
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Top-P parameter for nucleus sampling.
         * 
         * The option is a: <code>java.lang.Float</code> type.
         * 
         * Default: 0.95
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder topP(Float topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Top-P parameter for nucleus sampling.
         * 
         * The option will be converted to a <code>java.lang.Float</code> type.
         * 
         * Default: 0.95
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder topP(String topP) {
            doSetProperty("topP", topP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Google Vertex AI component.
     */
    public interface AdvancedGoogleVertexAIEndpointBuilder
            extends
                EndpointProducerBuilder {
        default GoogleVertexAIEndpointBuilder basic() {
            return (GoogleVertexAIEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The Google GenAI client for Vertex AI.
         * 
         * The option is a: <code>com.google.genai.Client</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder client(com.google.genai.Client client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * The Google GenAI client for Vertex AI.
         * 
         * The option will be converted to a
         * <code>com.google.genai.Client</code> type.
         * 
         * Group: advanced
         * 
         * @param client the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * The Google Cloud AI Platform Prediction Service client for rawPredict
         * operations.
         * 
         * The option is a:
         * <code>com.google.cloud.aiplatform.v1.PredictionServiceClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param predictionServiceClient the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder predictionServiceClient(com.google.cloud.aiplatform.v1.PredictionServiceClient predictionServiceClient) {
            doSetProperty("predictionServiceClient", predictionServiceClient);
            return this;
        }
        /**
         * The Google Cloud AI Platform Prediction Service client for rawPredict
         * operations.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.aiplatform.v1.PredictionServiceClient</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param predictionServiceClient the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleVertexAIEndpointBuilder predictionServiceClient(String predictionServiceClient) {
            doSetProperty("predictionServiceClient", predictionServiceClient);
            return this;
        }
    }

    public interface GoogleVertexAIBuilders {
        /**
         * Google Vertex AI (camel-google-vertexai)
         * Interact with Google Cloud Vertex AI generative models.
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-google-vertexai
         * 
         * @return the dsl builder for the headers' name.
         */
        default GoogleVertexAIHeaderNameBuilder googleVertexai() {
            return GoogleVertexAIHeaderNameBuilder.INSTANCE;
        }
        /**
         * Google Vertex AI (camel-google-vertexai)
         * Interact with Google Cloud Vertex AI generative models.
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-google-vertexai
         * 
         * Syntax: <code>google-vertexai:projectId:location:modelId</code>
         * 
         * Path parameter: projectId (required)
         * Google Cloud Project ID
         * 
         * Path parameter: location (required)
         * Google Cloud location/region (e.g., us-central1)
         * 
         * Path parameter: modelId (required)
         * Model ID to use for predictions
         * 
         * @param path projectId:location:modelId
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder googleVertexai(String path) {
            return GoogleVertexAIEndpointBuilderFactory.endpointBuilder("google-vertexai", path);
        }
        /**
         * Google Vertex AI (camel-google-vertexai)
         * Interact with Google Cloud Vertex AI generative models.
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-google-vertexai
         * 
         * Syntax: <code>google-vertexai:projectId:location:modelId</code>
         * 
         * Path parameter: projectId (required)
         * Google Cloud Project ID
         * 
         * Path parameter: location (required)
         * Google Cloud location/region (e.g., us-central1)
         * 
         * Path parameter: modelId (required)
         * Model ID to use for predictions
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path projectId:location:modelId
         * @return the dsl builder
         */
        default GoogleVertexAIEndpointBuilder googleVertexai(String componentName, String path) {
            return GoogleVertexAIEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Google Vertex AI component.
     */
    public static class GoogleVertexAIHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final GoogleVertexAIHeaderNameBuilder INSTANCE = new GoogleVertexAIHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code
         * org.apache.camel.component.google.vertexai.GoogleVertexAIOperations}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIOperation}.
         */
        public String googleVertexAIOperation() {
            return "CamelGoogleVertexAIOperation";
        }
        /**
         * The model ID to use for generation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIModelId}.
         */
        public String googleVertexAIModelId() {
            return "CamelGoogleVertexAIModelId";
        }
        /**
         * The project ID to use for the request.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIProjectId}.
         */
        public String googleVertexAIProjectId() {
            return "CamelGoogleVertexAIProjectId";
        }
        /**
         * The location/region to use for the request.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAILocation}.
         */
        public String googleVertexAILocation() {
            return "CamelGoogleVertexAILocation";
        }
        /**
         * The temperature parameter for generation (0.0-1.0).
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAITemperature}.
         */
        public String googleVertexAITemperature() {
            return "CamelGoogleVertexAITemperature";
        }
        /**
         * The top-p parameter for generation.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAITopP}.
         */
        public String googleVertexAITopP() {
            return "CamelGoogleVertexAITopP";
        }
        /**
         * The top-k parameter for generation.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAITopK}.
         */
        public String googleVertexAITopK() {
            return "CamelGoogleVertexAITopK";
        }
        /**
         * The maximum number of output tokens.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIMaxOutputTokens}.
         */
        public String googleVertexAIMaxOutputTokens() {
            return "CamelGoogleVertexAIMaxOutputTokens";
        }
        /**
         * The number of candidate responses to generate.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIcandidateCount}.
         */
        public String googleVertexAIcandidateCount() {
            return "CamelGoogleVertexAIcandidateCount";
        }
        /**
         * The streaming output mode (complete or chunks).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleVertexAIStreamOutputMode}.
         */
        public String googleVertexAIStreamOutputMode() {
            return "CamelGoogleVertexAIStreamOutputMode";
        }
        /**
         * The prompt text for text generation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIPrompt}.
         */
        public String googleVertexAIPrompt() {
            return "CamelGoogleVertexAIPrompt";
        }
        /**
         * The chat messages for chat generation.
         * 
         * The option is a: {@code
         * java.util.List<com.google.cloud.aiplatform.v1.Content>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIChatMessages}.
         */
        public String googleVertexAIChatMessages() {
            return "CamelGoogleVertexAIChatMessages";
        }
        /**
         * The system instruction for the model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleVertexAISystemInstruction}.
         */
        public String googleVertexAISystemInstruction() {
            return "CamelGoogleVertexAISystemInstruction";
        }
        /**
         * The safety settings for content filtering.
         * 
         * The option is a: {@code
         * java.util.List<com.google.cloud.aiplatform.v1.SafetySetting>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAISafetySettings}.
         */
        public String googleVertexAISafetySettings() {
            return "CamelGoogleVertexAISafetySettings";
        }
        /**
         * The finish reason from the response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIFinishReason}.
         */
        public String googleVertexAIFinishReason() {
            return "CamelGoogleVertexAIFinishReason";
        }
        /**
         * The number of tokens in the prompt.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleVertexAIPromptTokenCount}.
         */
        public String googleVertexAIPromptTokenCount() {
            return "CamelGoogleVertexAIPromptTokenCount";
        }
        /**
         * The number of tokens in the response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleVertexAICandidatesTokenCount}.
         */
        public String googleVertexAICandidatesTokenCount() {
            return "CamelGoogleVertexAICandidatesTokenCount";
        }
        /**
         * The total token count (prompt response).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAITotalTokenCount}.
         */
        public String googleVertexAITotalTokenCount() {
            return "CamelGoogleVertexAITotalTokenCount";
        }
        /**
         * The safety ratings from the response.
         * 
         * The option is a: {@code
         * java.util.List<com.google.cloud.aiplatform.v1.SafetyRating>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAISafetyRatings}.
         */
        public String googleVertexAISafetyRatings() {
            return "CamelGoogleVertexAISafetyRatings";
        }
        /**
         * Whether the content was blocked by safety filters.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIContentBlocked}.
         */
        public String googleVertexAIContentBlocked() {
            return "CamelGoogleVertexAIContentBlocked";
        }
        /**
         * The number of chunks received in streaming response.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIChunkCount}.
         */
        public String googleVertexAIChunkCount() {
            return "CamelGoogleVertexAIChunkCount";
        }
        /**
         * Publisher name for partner models (e.g., anthropic, meta, mistralai).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIPublisher}.
         */
        public String googleVertexAIPublisher() {
            return "CamelGoogleVertexAIPublisher";
        }
        /**
         * The raw JSON response from rawPredict operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleVertexAIRawResponse}.
         */
        public String googleVertexAIRawResponse() {
            return "CamelGoogleVertexAIRawResponse";
        }
        /**
         * Anthropic API version for Claude models.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleVertexAIAnthropicVersion}.
         */
        public String googleVertexAIAnthropicVersion() {
            return "CamelGoogleVertexAIAnthropicVersion";
        }
    }
    static GoogleVertexAIEndpointBuilder endpointBuilder(String componentName, String path) {
        class GoogleVertexAIEndpointBuilderImpl extends AbstractEndpointBuilder implements GoogleVertexAIEndpointBuilder, AdvancedGoogleVertexAIEndpointBuilder {
            public GoogleVertexAIEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new GoogleVertexAIEndpointBuilderImpl(path);
    }
}