/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.mail;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.google.api.services.gmail.Gmail.Users.Drafts}.
 */
@ApiParams(apiName = "drafts", 
           description = "The drafts collection of methods",
           apiMethods = {@ApiMethod(methodName = "create", description="Creates a new draft with the DRAFT label", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$Create create(String userId, com.google.api.services.gmail.model.Draft content)", "com.google.api.services.gmail.Gmail$Users$Drafts$Create create(String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "delete", description="Immediately and permanently deletes the specified draft", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$Delete delete(String userId, String id)"}), @ApiMethod(methodName = "get", description="Gets the specified draft", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$Get get(String userId, String id)"}), @ApiMethod(methodName = "list", description="Lists the drafts in the user's mailbox", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$List list(String userId)"}), @ApiMethod(methodName = "send", description="Sends the specified, existing draft to the recipients in the To, Cc, and Bcc headers", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$Send send(String userId, com.google.api.services.gmail.model.Draft content)", "com.google.api.services.gmail.Gmail$Users$Drafts$Send send(String userId, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "update", description="Replaces a draft's content", signatures={"com.google.api.services.gmail.Gmail$Users$Drafts$Update update(String userId, String id, com.google.api.services.gmail.model.Draft content)", "com.google.api.services.gmail.Gmail$Users$Drafts$Update update(String userId, String id, com.google.api.services.gmail.model.Draft content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), }, aliases = {})
@UriParams
@Configurer(extended = true)
public final class GmailUsersDraftsEndpointConfiguration extends GoogleMailConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "create", description="The com.google.api.services.gmail.model.Draft media metadata or null if none"), @ApiMethod(methodName = "send", description="The com.google.api.services.gmail.model.Draft media metadata or null if none"), @ApiMethod(methodName = "update", description="The com.google.api.services.gmail.model.Draft media metadata or null if none")})
    private com.google.api.services.gmail.model.Draft content;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "get", description="The format to return the draft in")})
    private java.lang.String format;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "delete", description="The ID of the draft to delete"), @ApiMethod(methodName = "get", description="The ID of the draft to retrieve"), @ApiMethod(methodName = "update")})
    private String id;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Include drafts from SPAM and TRASH in the results")})
    private java.lang.Boolean includeSpamTrash;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Maximum number of drafts to return")})
    private java.lang.Long maxResults;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "create", description="The media HTTP content"), @ApiMethod(methodName = "send", description="The media HTTP content"), @ApiMethod(methodName = "update", description="The media HTTP content")})
    private com.google.api.client.http.AbstractInputStreamContent mediaContent;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Page token to retrieve a specific page of results in the list")})
    private java.lang.String pageToken;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "list", description="Only return draft messages matching the specified query")})
    private java.lang.String q;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "create", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "create", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "delete", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "get", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "list", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "send", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "send", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "update", description="The user's email address. The special value me can be used to indicate the authenticated user. default: meparam id The ID of the draft to update."), @ApiMethod(methodName = "update", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me")})
    private String userId;

    public com.google.api.services.gmail.model.Draft getContent() {
        return content;
    }

    public void setContent(com.google.api.services.gmail.model.Draft content) {
        this.content = content;
    }

    public java.lang.String getFormat() {
        return format;
    }

    public void setFormat(java.lang.String format) {
        this.format = format;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public java.lang.Boolean getIncludeSpamTrash() {
        return includeSpamTrash;
    }

    public void setIncludeSpamTrash(java.lang.Boolean includeSpamTrash) {
        this.includeSpamTrash = includeSpamTrash;
    }

    public java.lang.Long getMaxResults() {
        return maxResults;
    }

    public void setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
    }

    public com.google.api.client.http.AbstractInputStreamContent getMediaContent() {
        return mediaContent;
    }

    public void setMediaContent(com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        this.mediaContent = mediaContent;
    }

    public java.lang.String getPageToken() {
        return pageToken;
    }

    public void setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
    }

    public java.lang.String getQ() {
        return q;
    }

    public void setQ(java.lang.String q) {
        this.q = q;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
