/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.crypto.SslTrustUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.http.HttpToolResponse;
import org.apache.brooklyn.util.http.TrustingSslSocketFactory;
import org.apache.brooklyn.util.net.URLParamEncoder;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTool {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTool.class);
    static final ExecutorService executor = Executors.newCachedThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLConnection connectToUrl(String u) throws Exception {
        final URL url = new URL(u);
        final AtomicReference exception = new AtomicReference();
        Future<URLConnection> f = executor.submit(new Callable<URLConnection>(){

            @Override
            public URLConnection call() {
                try {
                    HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String s, SSLSession sslSession) {
                            return true;
                        }
                    });
                    URLConnection connection = url.openConnection();
                    TrustingSslSocketFactory.configure(connection);
                    connection.connect();
                    connection.getContentLength();
                    return connection;
                }
                catch (Exception e) {
                    exception.set(e);
                    LOG.debug("Error connecting to url " + url + " (propagating): " + e, (Throwable)e);
                    return null;
                }
            }
        });
        try {
            URLConnection result = null;
            try {
                result = f.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Error connecting to url " + url + ", probably timed out (rethrowing): " + e);
                throw new IllegalStateException("Connect to URL not complete within 60 seconds, for url " + url + ": " + e);
            }
            if (exception.get() != null) {
                LOG.debug("Error connecting to url " + url + ", thread caller of " + exception, new Throwable("source of rethrown error " + exception));
                throw (Exception)exception.get();
            }
            URLConnection uRLConnection = result;
            return uRLConnection;
        }
        finally {
            f.cancel(true);
        }
    }

    public static int getHttpStatusCode(String url) throws Exception {
        URLConnection connection = HttpTool.connectToUrl(url);
        long startTime = System.currentTimeMillis();
        int status = ((HttpURLConnection)connection).getResponseCode();
        HttpTool.consumeAndCloseQuietly((HttpURLConnection)connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connection to {} ({}ms) gives {}", new Object[]{url, System.currentTimeMillis() - startTime, status});
        }
        return status;
    }

    public static String getContent(String url) {
        try {
            return Streams.readFullyStringAndClose(SslTrustUtils.trustAll(new URL(url).openConnection()).getInputStream());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorContent(String url) {
        try {
            int status;
            String err;
            HttpURLConnection connection = (HttpURLConnection)HttpTool.connectToUrl(url);
            long startTime = System.currentTimeMillis();
            try {
                InputStream errStream = connection.getErrorStream();
                err = Streams.readFullyStringAndClose(errStream);
                status = connection.getResponseCode();
            }
            finally {
                HttpTool.closeQuietly(connection);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("read of err {} ({}ms) complete; http code {}", new Object[]{url, Time.makeTimeStringRounded(System.currentTimeMillis() - startTime), status});
            }
            return err;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static void consumeAndCloseQuietly(HttpURLConnection connection) {
        try {
            Streams.readFully(connection.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpTool.closeQuietly(connection);
    }

    public static void closeQuietly(HttpURLConnection connection) {
        try {
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection.getInputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection.getErrorStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HttpClientBuilder httpClientBuilder() {
        return new HttpClientBuilder();
    }

    public static HttpToolResponse httpGet(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpGet req = (HttpGet)new HttpGetBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpGet(HttpClient httpClient, URI uri, Multimap<String, String> headers) {
        HttpGet req = (HttpGet)new HttpGetBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPost(HttpClient httpClient, URI uri, Multimap<String, String> headers, byte[] body) {
        HttpPost req = (HttpPost)new HttpPostBuilder(uri).headers(headers).body(body).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPost(HttpClient httpClient, URI uri, Map<String, String> headers, byte[] body) {
        HttpPost req = (HttpPost)new HttpPostBuilder(uri).headers(headers).body(body).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPut(HttpClient httpClient, URI uri, Multimap<String, String> headers, byte[] body) {
        HttpPut req = (HttpPut)new HttpPutBuilder(uri).headers(headers).body(body).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPut(HttpClient httpClient, URI uri, Map<String, String> headers, byte[] body) {
        HttpPut req = (HttpPut)new HttpPutBuilder(uri).headers(headers).body(body).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpPost(HttpClient httpClient, URI uri, Map<String, String> headers, Map<String, String> params) {
        HttpPost req = (HttpPost)new HttpPostBuilder(uri).body(params).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpDelete(HttpClient httpClient, URI uri, Multimap<String, String> headers) {
        HttpDelete req = (HttpDelete)new HttpDeleteBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpDelete(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpDelete req = (HttpDelete)new HttpDeleteBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpHead(HttpClient httpClient, URI uri, Multimap<String, String> headers) {
        HttpHead req = (HttpHead)new HttpHeadBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    public static HttpToolResponse httpHead(HttpClient httpClient, URI uri, Map<String, String> headers) {
        HttpHead req = (HttpHead)new HttpHeadBuilder(uri).headers(headers).build();
        return HttpTool.execAndConsume(httpClient, (HttpUriRequest)req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpToolResponse execAndConsume(HttpClient httpClient, HttpUriRequest req) {
        HttpToolResponse httpToolResponse;
        long startTime = System.currentTimeMillis();
        HttpResponse httpResponse = httpClient.execute(req);
        try {
            httpToolResponse = new HttpToolResponse(httpResponse, startTime);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                throw throwable;
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        return httpToolResponse;
    }

    public static boolean isStatusCodeHealthy(int code) {
        return code >= 200 && code <= 299;
    }

    public static String toBasicAuthorizationValue(UsernamePasswordCredentials credentials) {
        return "Basic " + Base64.encodeBase64String((byte[])(credentials.getUserName() + ":" + credentials.getPassword()).getBytes());
    }

    public static String encodeUrlParams(Map<?, ?> data) {
        if (data == null) {
            return "";
        }
        Iterable args = Iterables.transform(data.entrySet(), (Function)new Function<Map.Entry<?, ?>, String>(){

            public String apply(Map.Entry<?, ?> entry) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                return URLParamEncoder.encode(Strings.toString(k)) + (v != null ? "=" + URLParamEncoder.encode(Strings.toString(v)) : "");
            }
        });
        return Joiner.on((String)"&").join(args);
    }

    public static class HttpPutBuilder
    extends HttpRequestBuilder<HttpPut> {
        public HttpPutBuilder(URI uri) {
            super(HttpPut.class);
            this.uri(uri);
        }
    }

    public static class HttpPostBuilder
    extends HttpRequestBuilder<HttpPost> {
        public HttpPostBuilder(URI uri) {
            super(HttpPost.class);
            this.uri(uri);
        }
    }

    public static class HttpDeleteBuilder
    extends HttpRequestBuilder<HttpDelete> {
        public HttpDeleteBuilder(URI uri) {
            super(HttpDelete.class);
            this.uri(uri);
        }
    }

    public static class HttpHeadBuilder
    extends HttpRequestBuilder<HttpHead> {
        public HttpHeadBuilder(URI uri) {
            super(HttpHead.class);
            this.uri(uri);
        }
    }

    public static class HttpGetBuilder
    extends HttpRequestBuilder<HttpGet> {
        public HttpGetBuilder(URI uri) {
            super(HttpGet.class);
            this.uri(uri);
        }
    }

    public static class HttpRequestBuilder<R extends HttpRequestBase> {
        private Class<R> requestClass;
        private Map<String, String> headers;
        private URI uri;
        private HttpEntity body;

        public HttpRequestBuilder(Class<R> requestClass) {
            this.requestClass = requestClass;
            this.headers = MutableMap.of();
        }

        public HttpRequestBuilder<R> uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public HttpRequestBuilder<R> headers(Map<String, String> headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        public HttpRequestBuilder<R> headers(Multimap<String, String> headers) {
            if (headers != null) {
                for (Map.Entry entry : headers.entries()) {
                    this.headers.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return this;
        }

        public HttpRequestBuilder<R> body(byte[] body) {
            if (body != null) {
                this.body = new ByteArrayEntity(body);
            }
            return this;
        }

        public HttpRequestBuilder<R> body(String body) {
            if (body != null) {
                this.body(body.getBytes(Charset.forName("UTF-8")));
            }
            return this;
        }

        public HttpRequestBuilder<R> body(Map<String, String> body) {
            if (body != null) {
                ArrayList<BasicNameValuePair> httpParams = new ArrayList<BasicNameValuePair>(body.size());
                for (Map.Entry<String, String> param : body.entrySet()) {
                    httpParams.add(new BasicNameValuePair(param.getKey(), param.getValue()));
                }
                this.body = new UrlEncodedFormEntity(httpParams);
            }
            return this;
        }

        public R build() {
            try {
                HttpRequestBase request = (HttpRequestBase)this.requestClass.newInstance();
                request.setURI(this.uri);
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
                if (this.body != null) {
                    if (request instanceof HttpPost) {
                        ((HttpPost)request).setEntity(this.body);
                    } else if (request instanceof HttpPut) {
                        ((HttpPut)request).setEntity(this.body);
                    } else {
                        throw new Exception(this.requestClass.getSimpleName() + " does not support a request body");
                    }
                }
                return (R)request;
            }
            catch (Exception e) {
                LOG.warn("Cannot create the HTTP request for uri {}", (Object)this.uri);
                throw Exceptions.propagate(e);
            }
        }
    }

    public static class HttpClientBuilder {
        private ClientConnectionManager clientConnectionManager;
        private HttpParams httpParams;
        private URI uri;
        private Integer port;
        private Credentials credentials;
        private boolean laxRedirect;
        private Boolean https;
        private SchemeSocketFactory socketFactory;
        private ConnectionReuseStrategy reuseStrategy;
        private boolean trustAll;
        private boolean trustSelfSigned;

        public static HttpClientBuilder fromBuilder(HttpClientBuilder other) {
            HttpClientBuilder result = HttpTool.httpClientBuilder();
            result.clientConnectionManager = other.clientConnectionManager;
            result.httpParams = other.httpParams;
            result.uri = other.uri;
            result.port = other.port;
            result.credentials = other.credentials;
            result.laxRedirect = other.laxRedirect;
            result.https = other.https;
            result.socketFactory = other.socketFactory;
            result.reuseStrategy = other.reuseStrategy;
            result.trustAll = other.trustAll;
            result.trustSelfSigned = other.trustSelfSigned;
            return result;
        }

        public HttpClientBuilder clientConnectionManager(ClientConnectionManager val) {
            this.clientConnectionManager = (ClientConnectionManager)Preconditions.checkNotNull((Object)val, (Object)"clientConnectionManager");
            return this;
        }

        public HttpClientBuilder httpParams(HttpParams val) {
            Preconditions.checkState((this.httpParams == null ? 1 : 0) != 0, (Object)"Must not call httpParams multiple times, or after other methods like connectionTimeout");
            this.httpParams = (HttpParams)Preconditions.checkNotNull((Object)val, (Object)"httpParams");
            return this;
        }

        public HttpClientBuilder connectionTimeout(Duration val) {
            long millis;
            if (this.httpParams == null) {
                this.httpParams = new BasicHttpParams();
            }
            if ((millis = ((Duration)Preconditions.checkNotNull((Object)val, (Object)"connectionTimeout")).toMilliseconds()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("HttpClient only accepts upto max-int millis for connectionTimeout, but given " + val);
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParams, (int)((int)millis));
            return this;
        }

        public HttpClientBuilder socketTimeout(Duration val) {
            long millis;
            if (this.httpParams == null) {
                this.httpParams = new BasicHttpParams();
            }
            if ((millis = ((Duration)Preconditions.checkNotNull((Object)val, (Object)"socketTimeout")).toMilliseconds()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("HttpClient only accepts upto max-int millis for socketTimeout, but given " + val);
            }
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)((int)millis));
            return this;
        }

        public HttpClientBuilder reuseStrategy(ConnectionReuseStrategy val) {
            this.reuseStrategy = (ConnectionReuseStrategy)Preconditions.checkNotNull((Object)val, (Object)"reuseStrategy");
            return this;
        }

        public HttpClientBuilder uri(String val) {
            return this.uri(URI.create((String)Preconditions.checkNotNull((Object)val, (Object)"uri")));
        }

        public HttpClientBuilder uri(URI val) {
            this.uri = (URI)Preconditions.checkNotNull((Object)val, (Object)"uri");
            if (this.https == null) {
                this.https = "https".equalsIgnoreCase(this.uri.getScheme());
            }
            return this;
        }

        public HttpClientBuilder port(int val) {
            this.port = val;
            return this;
        }

        public HttpClientBuilder credentials(Credentials val) {
            this.credentials = (Credentials)Preconditions.checkNotNull((Object)val, (Object)"credentials");
            return this;
        }

        public HttpClientBuilder credential(Optional<? extends Credentials> val) {
            if (val.isPresent()) {
                this.credentials = (Credentials)val.get();
            }
            return this;
        }

        public HttpClientBuilder laxRedirect(boolean val) {
            this.laxRedirect = val;
            return this;
        }

        public HttpClientBuilder https(boolean val) {
            this.https = val;
            return this;
        }

        public HttpClientBuilder socketFactory(SchemeSocketFactory val) {
            this.socketFactory = (SchemeSocketFactory)Preconditions.checkNotNull((Object)val, (Object)"socketFactory");
            return this;
        }

        public HttpClientBuilder trustAll() {
            return this.trustAll(true);
        }

        public HttpClientBuilder trustSelfSigned() {
            return this.trustSelfSigned(true);
        }

        public HttpClientBuilder trustAll(boolean val) {
            this.trustAll = val;
            return this;
        }

        public HttpClientBuilder trustSelfSigned(boolean val) {
            this.trustSelfSigned = val;
            return this;
        }

        public HttpClient build() {
            DefaultHttpClient httpClient = new DefaultHttpClient(this.clientConnectionManager);
            httpClient.setParams(this.httpParams);
            if (this.laxRedirect) {
                httpClient.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            }
            if (this.reuseStrategy != null) {
                httpClient.setReuseStrategy(this.reuseStrategy);
            }
            if (this.https == Boolean.TRUE || this.uri != null && this.uri.toString().startsWith("https:")) {
                try {
                    if (this.port == null) {
                        this.port = this.uri != null && this.uri.getPort() >= 0 ? this.uri.getPort() : 443;
                    }
                    if (this.socketFactory == null) {
                        X509HostnameVerifier hostnameVerifier;
                        TrustAllStrategy trustStrategy;
                        if (this.trustAll) {
                            trustStrategy = new TrustAllStrategy();
                            hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            this.socketFactory = new SSLSocketFactory((TrustStrategy)trustStrategy, hostnameVerifier);
                        } else if (this.trustSelfSigned) {
                            trustStrategy = new TrustSelfSignedStrategy();
                            hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            this.socketFactory = new SSLSocketFactory((TrustStrategy)trustStrategy, hostnameVerifier);
                        }
                    }
                    if (this.socketFactory != null) {
                        Scheme sch = new Scheme("https", this.port.intValue(), this.socketFactory);
                        httpClient.getConnectionManager().getSchemeRegistry().register(sch);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error setting trust for uri {}", (Object)this.uri);
                    throw Exceptions.propagate(e);
                }
            }
            if (this.uri != null && this.credentials != null) {
                String hostname = this.uri.getHost();
                int port = this.uri.getPort();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(hostname, port), this.credentials);
            }
            if (this.uri == null && this.credentials != null) {
                LOG.warn("credentials have no effect in builder unless URI for host is specified");
            }
            return httpClient;
        }
    }

    public static class TrustAllStrategy
    implements TrustStrategy {
        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    }
}

