/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.ws;

import com.squareup.okhttp.internal.ws.Protocol;
import com.squareup.okhttp.internal.ws.WebSocket;
import java.io.IOException;
import java.util.Random;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class WebSocketWriter {
    private final boolean isClient;
    private final BufferedSink sink;
    private final Random random;
    private final FrameSink frameSink = new FrameSink();
    private boolean closed;
    private boolean activeWriter;
    private final byte[] maskKey = new byte[4];
    private final byte[] maskBuffer = new byte[2048];

    public WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink");
        }
        if (random == null) {
            throw new NullPointerException("random");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePing(Buffer payload) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(9, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePong(Buffer payload) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(10, payload);
        }
    }

    public void writeClose(int code, String reason) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        Buffer payload = null;
        if (code != 0) {
            if (code < 1000 || code >= 5000) {
                throw new IllegalArgumentException("Code must be in range [1000,5000).");
            }
            payload = new Buffer();
            payload.writeShort(code);
            if (reason != null) {
                payload.writeUtf8(reason);
            }
        } else if (reason != null) {
            throw new IllegalArgumentException("Code required to include reason.");
        }
        this.writeClose(payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClose(Buffer payload) throws IOException {
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            this.writeControlFrame(8, payload);
            this.closed = true;
        }
    }

    private void writeControlFrame(int opcode, Buffer payload) throws IOException {
        int length = 0;
        if (payload != null && (length = (int)payload.size()) > 125) {
            throw new IllegalArgumentException("Control frame payload must be less than 125B.");
        }
        int b0 = 0x80 | opcode;
        this.sink.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sink.writeByte(b1 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            if (payload != null) {
                this.writeAllMasked((BufferedSource)payload, length);
            }
        } else {
            this.sink.writeByte(b1);
            if (payload != null) {
                this.sink.writeAll((Source)payload);
            }
        }
        this.sink.flush();
    }

    public BufferedSink newMessageSink(WebSocket.PayloadType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.payloadType = type;
        this.frameSink.isFirstFrame = true;
        return Okio.buffer((Sink)this.frameSink);
    }

    public void sendMessage(WebSocket.PayloadType type, Buffer payload) throws IOException {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (payload == null) {
            throw new NullPointerException("payload == null");
        }
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        if (this.activeWriter) {
            throw new IllegalStateException("A message writer is active. Did you call close()?");
        }
        this.writeFrame(type, payload, payload.size(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFrame(WebSocket.PayloadType payloadType, Buffer source, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        int opcode = 0;
        if (isFirstFrame) {
            switch (payloadType) {
                case TEXT: {
                    opcode = 1;
                    break;
                }
                case BINARY: {
                    opcode = 2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown payload type: " + (Object)((Object)payloadType));
                }
            }
        }
        BufferedSink bufferedSink = this.sink;
        synchronized (bufferedSink) {
            int b0 = opcode;
            if (isFinal) {
                b0 |= 0x80;
            }
            this.sink.writeByte(b0);
            int b1 = 0;
            if (this.isClient) {
                b1 |= 0x80;
                this.random.nextBytes(this.maskKey);
            }
            if (byteCount <= 125L) {
                this.sink.writeByte(b1 |= (int)byteCount);
            } else if (byteCount <= 32767L) {
                this.sink.writeByte(b1 |= 0x7E);
                this.sink.writeShort((int)byteCount);
            } else {
                this.sink.writeByte(b1 |= 0x7F);
                this.sink.writeLong(byteCount);
            }
            if (this.isClient) {
                this.sink.write(this.maskKey);
                this.writeAllMasked((BufferedSource)source, byteCount);
            } else {
                this.sink.write(source, byteCount);
            }
            this.sink.flush();
        }
    }

    private void writeAllMasked(BufferedSource source, long byteCount) throws IOException {
        int read;
        for (long written = 0L; written < byteCount; written += (long)read) {
            int toRead = (int)Math.min(byteCount, (long)this.maskBuffer.length);
            read = source.read(this.maskBuffer, 0, toRead);
            if (read == -1) {
                throw new AssertionError();
            }
            Protocol.toggleMask(this.maskBuffer, read, this.maskKey, written);
            this.sink.write(this.maskBuffer, 0, read);
        }
    }

    private final class FrameSink
    implements Sink {
        private WebSocket.PayloadType payloadType;
        private boolean isFirstFrame;

        private FrameSink() {
        }

        public void write(Buffer source, long byteCount) throws IOException {
            WebSocketWriter.this.writeFrame(this.payloadType, source, byteCount, this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            BufferedSink bufferedSink = WebSocketWriter.this.sink;
            synchronized (bufferedSink) {
                WebSocketWriter.this.sink.flush();
            }
        }

        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            int length = 0;
            BufferedSink bufferedSink = WebSocketWriter.this.sink;
            synchronized (bufferedSink) {
                WebSocketWriter.this.sink.writeByte(128);
                if (WebSocketWriter.this.isClient) {
                    WebSocketWriter.this.sink.writeByte(0x80 | length);
                    WebSocketWriter.this.random.nextBytes(WebSocketWriter.this.maskKey);
                    WebSocketWriter.this.sink.write(WebSocketWriter.this.maskKey);
                } else {
                    WebSocketWriter.this.sink.writeByte(length);
                }
                WebSocketWriter.this.sink.flush();
            }
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

