/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.math.MathFunctions;
import org.apache.brooklyn.util.text.ByteSizeStrings;
import org.apache.brooklyn.util.time.Duration;

public class MachineAttributes {
    public static final AttributeSensor<Duration> UPTIME = Sensors.builder(Duration.class, (String)"machine.uptime").description("Current uptime").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> LOAD_AVERAGE = Sensors.builder(Double.class, (String)"machine.loadAverage").description("Current load average").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> CPU_USAGE = Sensors.builder(Double.class, (String)"machine.cpu").description("Current CPU usage").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> AVERAGE_CPU_USAGE = Sensors.builder(Double.class, (String)"cpu.average").description("Average CPU usage across the cluster").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Long> FREE_MEMORY = Sensors.builder(Long.class, (String)"machine.memory.free").description("Current free memory").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Long> TOTAL_MEMORY = Sensors.builder(Long.class, (String)"machine.memory.total").description("Total memory").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Long> USED_MEMORY = Sensors.builder(Long.class, (String)"machine.memory.used").description("Current memory usage").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> USED_MEMORY_DELTA_PER_SECOND_LAST = Sensors.builder(Double.class, (String)"memory.used.delta").description("Change in memory usage per second").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> USED_MEMORY_DELTA_PER_SECOND_IN_WINDOW = Sensors.builder(Double.class, (String)"memory.used.windowed").description("Average change in memory usage over 30s").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> USED_MEMORY_PERCENT = Sensors.builder(Double.class, (String)"memory.used.percent").description("The percentage of memory used").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    public static final AttributeSensor<Double> AVERAGE_USED_MEMORY_PERCENT = Sensors.builder(Double.class, (String)"memory.used.percent.average").description("Average percentage of memory used across the cluster").persistence(AttributeSensor.SensorPersistenceMode.NONE).build();
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private MachineAttributes() {
    }

    public static void init() {
        if (initialized.getAndSet(true)) {
            return;
        }
        Function<Double, Long> longValue = new Function<Double, Long>(){

            public Long apply(@Nullable Double input) {
                if (input == null) {
                    return null;
                }
                return input.longValue();
            }
        };
        RendererHints.register(CPU_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(AVERAGE_CPU_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(USED_MEMORY_PERCENT, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(AVERAGE_USED_MEMORY_PERCENT, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)2)));
        RendererHints.register(FREE_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(TOTAL_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)MathFunctions.times((long)1000L), (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY_DELTA_PER_SECOND_LAST, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)longValue, (Function)ByteSizeStrings.metric())));
        RendererHints.register(USED_MEMORY_DELTA_PER_SECOND_IN_WINDOW, (RendererHints.Hint)RendererHints.displayValue((Function)Functionals.chain((Function)longValue, (Function)ByteSizeStrings.metric())));
    }

    static {
        MachineAttributes.init();
    }
}

