/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.DeleteResult;
import org.jclouds.s3.xml.ErrorEntryHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeleteResultHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<DeleteResult> {
    public static final String DELETED_TAG = "Deleted";
    public static final String ERROR_TAG = "Error";
    private final ErrorEntryHandler errorEntryHandler = new ErrorEntryHandler();
    private StringBuilder deletedEntryAccumulator = new StringBuilder();
    private final ImmutableSet.Builder<String> deleted = ImmutableSet.builder();
    private final ImmutableMap.Builder<String, DeleteResult.Error> errors = ImmutableMap.builder();
    private boolean parsingDeletedEntry = false;
    private boolean parsingErrorEntry = false;

    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)DELETED_TAG)) {
            this.parsingDeletedEntry = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)ERROR_TAG)) {
            this.parsingErrorEntry = true;
        }
        if (this.parsingDeletedEntry) {
            this.deletedEntryAccumulator.setLength(0);
        } else if (this.parsingErrorEntry) {
            this.errorEntryHandler.startElement(uri, name, qName, attributes);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.parsingDeletedEntry) {
            this.deletedEntryAccumulator.append(chars, start, length);
        } else if (this.parsingErrorEntry) {
            this.errorEntryHandler.characters(chars, start, length);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)DELETED_TAG)) {
            this.parsingDeletedEntry = false;
            this.deleted.add((Object)this.deletedEntryAccumulator.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)ERROR_TAG)) {
            this.parsingErrorEntry = false;
            this.errors.put((Map.Entry)this.errorEntryHandler.getResult());
        }
        if (this.parsingErrorEntry) {
            this.errorEntryHandler.endElement(uri, name, qName);
        }
    }

    public DeleteResult getResult() {
        return new DeleteResult((Set<String>)this.deleted.build(), (Map<String, DeleteResult.Error>)this.errors.build());
    }
}

