/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputFluent;

public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>>
extends BaseFluent<A>
implements BuildOutputFluent<A> {
    private VisitableBuilder<? extends LocalObjectReference, ?> pushSecret;
    private VisitableBuilder<? extends ObjectReference, ?> to;

    public BuildOutputFluentImpl() {
    }

    public BuildOutputFluentImpl(BuildOutput instance) {
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
    }

    @Override
    public LocalObjectReference getPushSecret() {
        return this.pushSecret != null ? (LocalObjectReference)this.pushSecret.build() : null;
    }

    @Override
    public A withPushSecret(LocalObjectReference pushSecret) {
        this._visitables.remove(this.pushSecret);
        if (pushSecret != null) {
            this.pushSecret = new LocalObjectReferenceBuilder(pushSecret);
            this._visitables.add(this.pushSecret);
        }
        return (A)this;
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecret() {
        return new PushSecretNestedImpl();
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item) {
        return new PushSecretNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(LocalObjectReference item) {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : item);
    }

    @Override
    public A withNewPushSecret(String name) {
        return this.withPushSecret(new LocalObjectReference(name));
    }

    @Override
    public ObjectReference getTo() {
        return this.to != null ? (ObjectReference)this.to.build() : null;
    }

    @Override
    public A withTo(ObjectReference to) {
        this._visitables.remove(this.to);
        if (to != null) {
            this.to = new ObjectReferenceBuilder(to);
            this._visitables.add(this.to);
        }
        return (A)this;
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewToLike(ObjectReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewToLike(ObjectReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOutputFluentImpl that = (BuildOutputFluentImpl)o;
        if (this.pushSecret != null ? !this.pushSecret.equals(that.pushSecret) : that.pushSecret != null) {
            return false;
        }
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public class ToNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildOutputFluent.ToNested<N>>
    implements BuildOutputFluent.ToNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ToNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class PushSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildOutputFluent.PushSecretNested<N>>
    implements BuildOutputFluent.PushSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PushSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PushSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withPushSecret(this.builder.build());
        }

        @Override
        public N endPushSecret() {
            return this.and();
        }
    }
}

