/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.javax.annotation.Nullable;

public class Server
implements Comparable<Server> {
    private final long id;
    private final boolean isSandbox;
    private final String name;
    private final String description;
    private final ServerState state;
    private final Option datacenter;
    private final Option type;
    private final Option ram;
    private final Option os;
    private final Ip ip;
    private final ServerImage image;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServer(this);
    }

    @ConstructorProperties(value={"id", "isSandbox", "name", "description", "state", "datacenter", "type", "ram", "os", "ip", "image"})
    protected Server(long id, boolean isSandbox, String name, @Nullable String description, ServerState state, @Nullable Option datacenter, Option type, Option ram, Option os, Ip ip, ServerImage image) {
        this.id = id;
        this.isSandbox = isSandbox;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.description = description;
        this.state = (ServerState)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.datacenter = datacenter;
        this.type = (Option)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.ram = (Option)Preconditions.checkNotNull((Object)ram, (Object)"ram");
        this.os = (Option)Preconditions.checkNotNull((Object)os, (Object)"os");
        this.ip = (Ip)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.image = (ServerImage)Preconditions.checkNotNull((Object)image, (Object)"image");
    }

    public long getId() {
        return this.id;
    }

    public boolean isSandbox() {
        return this.isSandbox;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ServerState getState() {
        return this.state;
    }

    @Nullable
    public Option getDatacenter() {
        return this.datacenter;
    }

    public Option getType() {
        return this.type;
    }

    public Option getRam() {
        return this.ram;
    }

    public Option getOs() {
        return this.os;
    }

    public Ip getIp() {
        return this.ip;
    }

    public ServerImage getImage() {
        return this.image;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.isSandbox, this.name, this.description, this.state, this.datacenter, this.type, this.ram, this.os, this.ip, this.image});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server that = (Server)Server.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.isSandbox, (Object)that.isSandbox) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.datacenter, (Object)that.datacenter) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.ram, (Object)that.ram) && Objects.equal((Object)this.os, (Object)that.os) && Objects.equal((Object)this.ip, (Object)that.ip) && Objects.equal((Object)this.image, (Object)that.image);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("isSandbox", this.isSandbox).add("name", (Object)this.name).add("description", (Object)this.description).add("state", (Object)this.state).add("datacenter", (Object)this.datacenter).add("type", (Object)this.type).add("ram", (Object)this.ram).add("os", (Object)this.os).add("ip", (Object)this.ip).add("image", (Object)this.image);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Server that) {
        return Longs.compare((long)this.id, (long)that.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected boolean isSandbox;
        protected String name;
        protected String description;
        protected ServerState state;
        protected Option datacenter;
        protected Option type;
        protected Option ram;
        protected Option os;
        protected Ip ip;
        protected ServerImage image;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T isSandbox(boolean isSandbox) {
            this.isSandbox = isSandbox;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T state(ServerState state) {
            this.state = state;
            return this.self();
        }

        public T datacenter(Option datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public T type(Option type) {
            this.type = type;
            return this.self();
        }

        public T ram(Option ram) {
            this.ram = ram;
            return this.self();
        }

        public T os(Option os) {
            this.os = os;
            return this.self();
        }

        public T ip(Ip ip) {
            this.ip = ip;
            return this.self();
        }

        public T image(ServerImage image) {
            this.image = image;
            return this.self();
        }

        public Server build() {
            return new Server(this.id, this.isSandbox, this.name, this.description, this.state, this.datacenter, this.type, this.ram, this.os, this.ip, this.image);
        }

        public T fromServer(Server in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).isSandbox(in.isSandbox())).name(in.getName())).description(in.getDescription())).state(in.getState())).datacenter(in.getDatacenter())).type(in.getType())).ram(in.getRam())).os(in.getOs())).ip(in.getIp())).image(in.getImage());
        }
    }
}

