/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;

public enum OsFamily {
    UNRECOGNIZED(false),
    AIX,
    ALPINE,
    ARCH,
    CENTOS,
    DARWIN,
    DEBIAN,
    ESX,
    FEDORA,
    FREEBSD,
    GENTOO,
    HPUX,
    LINUX(false),
    COREOS,
    SMARTOS,
    AMZN_LINUX,
    MANDRIVA,
    NETBSD,
    OEL,
    OPENBSD,
    RHEL,
    SCIENTIFIC,
    GCEL,
    SIGAR,
    SLACKWARE,
    SOLARIS,
    SUSE,
    TURBOLINUX,
    CLOUD_LINUX,
    UBUNTU,
    WINDOWS;

    private final boolean prioritise;

    private OsFamily() {
        this.prioritise = true;
    }

    private OsFamily(boolean prioritise) {
        this.prioritise = prioritise;
    }

    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public boolean shouldPrioritise() {
        return this.prioritise;
    }

    public static OsFamily fromValue(String osFamily) {
        try {
            return OsFamily.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)osFamily, (Object)"osFamily")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    private static Predicate<OsFamily> predicateOnShouldPrioritise(final boolean prioritise) {
        return new Predicate<OsFamily>(){

            public boolean apply(OsFamily osFamily) {
                return osFamily.shouldPrioritise() == prioritise;
            }
        };
    }

    public static OsFamily[] proritisedValues() {
        return (OsFamily[])FluentIterable.from(Arrays.asList(OsFamily.values())).filter(OsFamily.predicateOnShouldPrioritise(true)).toArray(OsFamily.class);
    }

    public static OsFamily[] nonProritisedValues() {
        return (OsFamily[])FluentIterable.from(Arrays.asList(OsFamily.values())).filter(OsFamily.predicateOnShouldPrioritise(false)).toArray(OsFamily.class);
    }
}

