/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.brooklyn.rest.BrooklynRestApp;
import org.apache.brooklyn.rest.apidoc.RestApiResourceScanner;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class RestApiSetup {
    public static void installRest(ServletContextHandler context, Object ... providers) {
        RestApiSetup.initSwagger();
        BrooklynRestApp app = new BrooklynRestApp();
        for (Object o : providers) {
            app.singleton(o);
        }
        CXFNonSpringJaxrsServlet servlet = new CXFNonSpringJaxrsServlet((Application)app);
        servlet.setBus(BusFactory.newInstance().createBus());
        servlet.getBus().getInInterceptors().add(new GZIPInInterceptor());
        servlet.getBus().getInFaultInterceptors().add(new GZIPInInterceptor());
        servlet.getBus().getOutInterceptors().add(new GZIPOutInterceptor());
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        context.addServlet(servletHolder, "/v1/*");
    }

    @SafeVarargs
    public static void installServletFilters(ServletContextHandler context, Class<? extends Filter> ... filters) {
        RestApiSetup.installServletFilters(context, Arrays.asList(filters));
    }

    public static void installServletFilters(ServletContextHandler context, Collection<Class<? extends Filter>> filters) {
        for (Class<? extends Filter> filter : filters) {
            context.addFilter(filter, "/*", EnumSet.allOf(DispatcherType.class));
        }
    }

    public static void initSwagger() {
        ScannerFactory.setScanner((Scanner)new RestApiResourceScanner());
    }
}

