/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.policy;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.mgmt.rebind.RebindSupport;
import org.apache.brooklyn.api.mgmt.rebind.mementos.PolicyMemento;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicyType;
import org.apache.brooklyn.core.mgmt.rebind.BasicPolicyRebindSupport;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.policy.PolicyDynamicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicy
extends AbstractEntityAdjunct
implements Policy,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPolicy.class);
    protected String policyStatus;
    protected AtomicBoolean suspended = new AtomicBoolean(false);
    private final PolicyDynamicType policyType = new PolicyDynamicType(this);

    public AbstractPolicy() {
        this(Collections.emptyMap());
    }

    public AbstractPolicy(Map<?, ?> flags) {
        super((Map)flags);
        if (this.isLegacyConstruction() && !this.isLegacyNoConstructionInit()) {
            this.init();
        }
    }

    public PolicyType getPolicyType() {
        return this.policyType.getSnapshot();
    }

    public void suspend() {
        this.suspended.set(true);
    }

    public void resume() {
        this.suspended.set(false);
    }

    public boolean isSuspended() {
        if (this.suspended == null) {
            return true;
        }
        return this.suspended.get();
    }

    @Override
    public void destroy() {
        this.suspend();
        super.destroy();
    }

    @Override
    public boolean isRunning() {
        return !this.isSuspended() && !this.isDestroyed();
    }

    @Override
    protected void onChanged() {
        if (this.getManagementContext() != null) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        }
    }

    public RebindSupport<PolicyMemento> getRebindSupport() {
        return new BasicPolicyRebindSupport(this);
    }

    @Override
    public BrooklynObjectInternal.RelationSupportInternal<Policy> relations() {
        return super.relations();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.getId()).add("name", (Object)this.name).add("running", this.isRunning()).toString();
    }
}

