/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.SubscriptionManager;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.mgmt.internal.Subscription;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSubscriptionContext
implements SubscriptionContext {
    private static final Logger LOG = LoggerFactory.getLogger(BasicSubscriptionContext.class);
    private final SubscriptionManager manager;
    private final Object subscriber;
    private final Map<String, Object> flags;

    public BasicSubscriptionContext(SubscriptionManager manager, Object subscriber) {
        this((Map<String, ?>)ImmutableMap.of(), manager, subscriber);
    }

    public BasicSubscriptionContext(Map<String, ?> flags, SubscriptionManager manager, Object subscriber) {
        this.manager = manager;
        this.subscriber = subscriber;
        this.flags = JavaGroovyEquivalents.mapOf((Object)"subscriber", (Object)subscriber);
        if (flags != null) {
            this.flags.putAll(flags);
        }
    }

    @Deprecated
    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribe()");
        return this.subscribe(Collections.emptyMap(), producer, sensor, c);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribe(Map<String, ?> newFlags, Entity producer, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribe()");
        return this.subscribe(newFlags, producer, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribe(Collections.emptyMap(), producer, sensor, listener);
    }

    public <T> SubscriptionHandle subscribe(Map<String, ?> newFlags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribe((Map)subscriptionFlags, producer, sensor, listener);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribeToChildren()");
        return this.subscribeToChildren(Collections.emptyMap(), parent, sensor, c);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToChildren(Map<String, Object> newFlags, Entity parent, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribeToChildren()");
        return this.subscribeToChildren(newFlags, parent, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToChildren(Collections.emptyMap(), parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToChildren(Map<String, Object> newFlags, Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribeToChildren((Map)subscriptionFlags, parent, sensor, listener);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribeToMembers()");
        return this.subscribeToMembers(Collections.emptyMap(), parent, sensor, c);
    }

    @Deprecated
    public <T> SubscriptionHandle subscribeToMembers(Map<String, Object> newFlags, Group parent, Sensor<T> sensor, Closure c) {
        LOG.warn("Use of groovy.lang.Closure is deprecated in BasicSubscriptionContext.subscribeToMembers()");
        return this.subscribeToMembers(newFlags, parent, sensor, this.toSensorEventListener(c));
    }

    public <T> SubscriptionHandle subscribeToMembers(Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.subscribeToMembers(Collections.emptyMap(), parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToMembers(Map<String, Object> newFlags, Group parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        LinkedHashMap subscriptionFlags = Maps.newLinkedHashMap(this.flags);
        if (newFlags != null) {
            subscriptionFlags.putAll(newFlags);
        }
        return this.manager.subscribeToMembers((Map)subscriptionFlags, parent, sensor, listener);
    }

    public boolean unsubscribe(SubscriptionHandle subscriptionId) {
        Preconditions.checkNotNull((Object)subscriptionId, (Object)"subscriptionId must not be null");
        Preconditions.checkArgument((boolean)Objects.equal((Object)this.subscriber, (Object)((Subscription)subscriptionId).subscriber), (Object)("The subscriptionId is for a different " + this.subscriber + "; expected " + ((Subscription)subscriptionId).subscriber));
        return this.manager.unsubscribe(subscriptionId);
    }

    public <T> void publish(SensorEvent<T> event) {
        this.manager.publish(event);
    }

    public Set<SubscriptionHandle> getSubscriptions() {
        return this.manager.getSubscriptionsForSubscriber(this.subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unsubscribeAll() {
        ImmutableList subscriptionsCopy;
        int count = 0;
        Set<SubscriptionHandle> subscriptions = this.getSubscriptions();
        Set<SubscriptionHandle> set = subscriptions;
        synchronized (set) {
            subscriptionsCopy = ImmutableList.copyOf(subscriptions);
        }
        for (SubscriptionHandle s : subscriptionsCopy) {
            ++count;
            boolean result = this.unsubscribe(s);
            if (result) continue;
            LOG.warn("When unsubscribing from all of {}, unsubscribe of {} returned false", this.subscriber, (Object)s);
        }
        return count;
    }

    @Deprecated
    private <T> SensorEventListener<T> toSensorEventListener(final Closure c) {
        return new SensorEventListener<T>(){

            public void onEvent(SensorEvent<T> event) {
                c.call(event);
            }
        };
    }
}

