/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.objs.Identifiable;
import org.apache.brooklyn.core.mgmt.ha.MasterChooser;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class BasicMasterChooser
implements MasterChooser {
    private static final Logger LOG = LoggerFactory.getLogger(BasicMasterChooser.class);

    @Override
    public ManagementNodeSyncRecord choose(ManagementPlaneSyncRecord memento, Duration heartbeatTimeout, String ownNodeId) {
        ManagementNodeSyncRecord me;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Choosing new master from " + memento.getManagementNodes());
        }
        if ((me = (ManagementNodeSyncRecord)memento.getManagementNodes().get(ownNodeId)) == null) {
            LOG.warn("Management node details not known when choosing new master: " + memento + " / " + ownNodeId);
            return null;
        }
        Long nowIsh = me.getRemoteTimestamp();
        if (nowIsh == null) {
            LOG.warn("Management node for self missing timestamp when choosing new master: " + memento);
            return null;
        }
        List<ScoredRecord<?>> contenders = this.filterHealthy(memento, heartbeatTimeout, nowIsh);
        if (!contenders.isEmpty()) {
            return this.pick(contenders);
        }
        LOG.info("No valid management node found for choosing new master: contender=" + memento.getManagementNodes());
        return null;
    }

    protected ManagementNodeSyncRecord pick(List<ScoredRecord<?>> contenders) {
        ScoredRecord<?> min = null;
        for (ScoredRecord<?> x : contenders) {
            if (min != null && x.score.compareTo(min.score) >= 0) continue;
            min = x;
        }
        return min.record;
    }

    protected List<ScoredRecord<?>> filterHealthy(ManagementPlaneSyncRecord memento, Duration heartbeatTimeout, long nowIsh) {
        long oldestAcceptableTimestamp = nowIsh - heartbeatTimeout.toMilliseconds();
        MutableList contenders = MutableList.of();
        for (ManagementNodeSyncRecord contender : memento.getManagementNodes().values()) {
            boolean heartbeatOk;
            boolean statusOk = contender.getStatus() == ManagementNodeState.STANDBY || contender.getStatus() == ManagementNodeState.HOT_STANDBY || contender.getStatus() == ManagementNodeState.MASTER;
            Long remoteTimestamp = contender.getRemoteTimestamp();
            if (remoteTimestamp == null) {
                throw new IllegalStateException("Missing remote timestamp when performing master election: " + this + " / " + contender);
            }
            boolean bl = heartbeatOk = remoteTimestamp >= oldestAcceptableTimestamp;
            if (statusOk && heartbeatOk) {
                contenders.add(this.newScoredRecord(contender));
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Filtering choices of new master: contender=" + contender + "; statusOk=" + statusOk + "; heartbeatOk=" + heartbeatOk);
        }
        return contenders;
    }

    @VisibleForTesting
    protected List<ScoredRecord<?>> sort(List<ScoredRecord<?>> input) {
        ArrayList copy = new ArrayList(input);
        Collections.sort(copy);
        return copy;
    }

    protected ScoredRecord<?> newScoredRecord(ManagementNodeSyncRecord contender) {
        ScoredRecord r = new ScoredRecord();
        r.id = contender.getNodeId();
        r.record = contender;
        r.score = this.score(contender);
        return r;
    }

    protected abstract Comparable<?> score(ManagementNodeSyncRecord var1);

    public static class AlphabeticMasterChooser
    extends BasicMasterChooser {
        final boolean preferHotStandby;

        public AlphabeticMasterChooser(boolean preferHotStandby) {
            this.preferHotStandby = preferHotStandby;
        }

        public AlphabeticMasterChooser() {
            this.preferHotStandby = true;
        }

        protected AlphabeticChooserScore score(ManagementNodeSyncRecord contender) {
            AlphabeticChooserScore score = new AlphabeticChooserScore();
            score.priority = contender.getPriority() != null ? contender.getPriority() : 0L;
            score.brooklynVersion = contender.getBrooklynVersion();
            int n = contender.getBrooklynVersion() == null ? -2 : (score.versionBias = contender.getBrooklynVersion().toLowerCase().indexOf("snapshot") >= 0 ? -1 : 0);
            score.statePriority = this.preferHotStandby ? (contender.getStatus() == ManagementNodeState.MASTER ? 3 : (contender.getStatus() == ManagementNodeState.HOT_STANDBY ? 2 : (contender.getStatus() == ManagementNodeState.STANDBY ? 1 : -1))) : 0;
            score.nodeId = contender.getNodeId();
            return score;
        }
    }

    public static class AlphabeticChooserScore
    implements Comparable<AlphabeticChooserScore> {
        long priority;
        int versionBias;
        String brooklynVersion;
        int statePriority;
        String nodeId;

        @Override
        public int compareTo(AlphabeticChooserScore o) {
            if (o == null) {
                return -1;
            }
            return ComparisonChain.start().compare(o.priority, this.priority).compare(o.versionBias, this.versionBias).compare((Object)o.brooklynVersion, (Object)this.brooklynVersion, (Comparator)Ordering.from((Comparator)NaturalOrderComparator.INSTANCE).nullsFirst()).compare(o.statePriority, this.statePriority).compare((Object)this.nodeId, (Object)o.nodeId, (Comparator)Ordering.usingToString().nullsLast()).result();
        }
    }

    public static class ScoredRecord<T extends Comparable<T>>
    implements Identifiable,
    Comparable<ScoredRecord<T>> {
        String id;
        ManagementNodeSyncRecord record;
        T score;

        public String getId() {
            return this.id;
        }

        @Override
        public int compareTo(ScoredRecord<T> o) {
            return this.score.compareTo(o.score);
        }
    }
}

