/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public class AuthenticationResponse {
    private final String authToken;
    private final Map<String, URI> services;

    public AuthenticationResponse(String authToken, Map<String, URI> services) {
        this.authToken = (String)Preconditions.checkNotNull((Object)authToken, (Object)"authToken");
        this.services = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(services, (Object)"services")));
    }

    public Map<String, URI> getServices() {
        return this.services;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.authToken, this.services});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResponse)) {
            return false;
        }
        AuthenticationResponse that = (AuthenticationResponse)obj;
        return Objects.equal((Object)this.authToken, (Object)that.authToken) && Objects.equal(this.services, that.services);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authToken", (Object)this.authToken).add("services", this.services).toString();
    }
}

