/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeSerializer1
implements Serializer {
    private static final String pathSeparator = "_";
    private static final String doubleSeparator = "__";
    private static final String dotSeparator = ".";
    private static final String arrayDescriptor = "$$";
    private static final String tokenSeparator = "_";

    @Override
    public Reflections read(InputStream inputStream) {
        throw new UnsupportedOperationException("read is not implemented on JavaCodeSerializer");
    }

    @Override
    public File save(Reflections reflections, String name) {
        String className;
        String packageName;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String filename = name.replace('.', '/').concat(".java");
        File file = Utils.prepareFile(filename);
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            packageName = "";
            className = name.substring(name.lastIndexOf(47) + 1);
        } else {
            packageName = name.substring(name.lastIndexOf(47) + 1, lastDot);
            className = name.substring(lastDot + 1);
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("//generated using Reflections JavaCodeSerializer").append(" [").append(new Date()).append("]").append("\n");
            if (packageName.length() != 0) {
                sb.append("package ").append(packageName).append(";\n");
                sb.append("\n");
            }
            sb.append("public interface ").append(className).append(" {\n\n");
            sb.append(this.toString(reflections));
            sb.append("}\n");
            Files.write((CharSequence)sb.toString(), (File)new File(filename), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections) {
        if (reflections.getStore().get(TypeElementsScanner.class.getSimpleName()).isEmpty() && Reflections.log != null) {
            Reflections.log.warn("JavaCodeSerializer needs TypeElementsScanner configured");
        }
        Writer sb = new Writer();
        String prev = "";
        boolean prevEmpty = false;
        ArrayList keys = Lists.newArrayList((Iterable)reflections.getStore().get(TypeElementsScanner.class.getSimpleName()).keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String cn;
            String fqn = key.replace("$", dotSeparator);
            String common = this.commonPath(prev, fqn);
            String string = cn = fqn.contains(dotSeparator) ? fqn.substring(fqn.lastIndexOf(dotSeparator) + 1) : "";
            if (prev.length() > common.length() + 1) {
                for (String ignored : prev.substring(common.length() + 1).split("\\.")) {
                    if (!prevEmpty) {
                        sb.indentLeft();
                    } else {
                        prevEmpty = false;
                    }
                    sb.append("}\n");
                }
            }
            if (fqn.length() > common.length()) {
                String[] split = fqn.substring(common.length()).split("\\.");
                for (int i = 0; i < split.length - 1; ++i) {
                    String path = split[i];
                    if (path.length() > 0) {
                        sb.indentRight().append("public interface ").append(path).append(" {\n");
                        continue;
                    }
                    --sb.indent;
                }
            }
            Data data = new Data(reflections, key);
            sb.indentRight().append("public enum ").append(cn).append(" {");
            if (!data.elements.isEmpty()) {
                int i;
                sb.append("\n");
                ++sb.indent;
                int fs = data.fields.size();
                int ms = data.elements.size() - fs;
                int ss = fs + ms;
                if (fs > 0) {
                    sb.indent().append("//fields").append("\n");
                    for (i = 0; i < fs; ++i) {
                        sb.indent().append((String)data.elements.get(i)).append(i < ss - 1 ? "," : "").append("\n");
                    }
                }
                if (ms > 0) {
                    sb.indent().append("//methods").append("\n");
                    for (i = fs; i < ss; ++i) {
                        sb.indent().append((String)data.elements.get(i)).append(i < ss - 1 ? "," : "").append("\n");
                    }
                }
            }
            prevEmpty = data.elements.isEmpty();
            prev = fqn;
        }
        for (String ignored : prev.split("\\.")) {
            sb.indentLeft().append("}\n");
        }
        return sb.toString();
    }

    private String commonPath(String prev, String fqn) {
        int p;
        int maxPrefixLength = Math.min(prev.length(), fqn.length());
        for (p = 0; p < maxPrefixLength && prev.charAt(p) == fqn.charAt(p); ++p) {
        }
        if (this.aBoolean(prev, p) || this.aBoolean(fqn, p)) {
            p = prev.lastIndexOf(dotSeparator);
        }
        return prev.subSequence(0, p).toString();
    }

    private boolean aBoolean(String prev, int p) {
        return p - 1 >= 0 && p - 1 <= prev.length() - 1 && prev.charAt(p - 1) != '.';
    }

    private String name(String candidate, List<String> prev, int offset) {
        String normalized = candidate.replace(dotSeparator, "_");
        for (int i = 0; i < offset; ++i) {
            if (!normalized.equals(prev.get(i))) continue;
            return this.name(normalized + "_", prev, offset);
        }
        return !normalized.contains("$") ? normalized : Joiner.on((String)dotSeparator).join((Object[])normalized.split("\\$"));
    }

    public static Class<?> resolveClassOf(Class element) throws ClassNotFoundException {
        LinkedList ognl = Lists.newLinkedList();
        for (Class<?> cursor = element; cursor != null; cursor = cursor.getDeclaringClass()) {
            ognl.addFirst(cursor.getSimpleName());
        }
        String classOgnl = Joiner.on((String)dotSeparator).join(ognl.subList(1, ognl.size())).replace(".$", "$");
        return Class.forName(classOgnl);
    }

    public static Class<?> resolveClass(Class aClass) {
        try {
            return JavaCodeSerializer1.resolveClassOf(aClass);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to class " + aClass.getName(), e);
        }
    }

    public static Field resolveField(Class aField) {
        try {
            String name = aField.getSimpleName();
            Class<?> declaringClass = aField.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer1.resolveClassOf(declaringClass).getDeclaredField(name);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to field " + aField.getName(), e);
        }
    }

    public static Annotation resolveAnnotation(Class annotation) {
        try {
            String name = annotation.getSimpleName().replace("_", dotSeparator);
            Class<?> declaringClass = annotation.getDeclaringClass().getDeclaringClass();
            Class<?> aClass = JavaCodeSerializer1.resolveClassOf(declaringClass);
            Class<?> aClass1 = ReflectionUtils.forName(name, new ClassLoader[0]);
            return aClass.getAnnotation(aClass1);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to annotation " + annotation.getName(), e);
        }
    }

    public static Method resolveMethod(Class aMethod) {
        String methodOgnl = aMethod.getSimpleName();
        try {
            Class[] paramTypes;
            String methodName;
            if (methodOgnl.contains("_")) {
                methodName = methodOgnl.substring(0, methodOgnl.indexOf("_"));
                String[] params = methodOgnl.substring(methodOgnl.indexOf("_") + 1).split(doubleSeparator);
                paramTypes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String typeName = params[i].replace(arrayDescriptor, "[]").replace("_", dotSeparator);
                    paramTypes[i] = ReflectionUtils.forName(typeName, new ClassLoader[0]);
                }
            } else {
                methodName = methodOgnl;
                paramTypes = null;
            }
            Class<?> declaringClass = aMethod.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer1.resolveClassOf(declaringClass).getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to method " + aMethod.getName(), e);
        }
    }

    private class Data {
        private List<String> annotations = Lists.newArrayList();
        private List<String> fields = Lists.newArrayList();
        private Multimap<String, String> methods;
        private List<String> elements;

        public Data(Reflections reflections, String key) {
            this.methods = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

                public Set<String> get() {
                    return Sets.newHashSet();
                }
            });
            for (String element : reflections.getStore().get(TypeElementsScanner.class.getSimpleName(), key)) {
                if (element.startsWith("@")) {
                    this.annotations.add(element.substring(1));
                    continue;
                }
                if (element.contains("(")) {
                    if (element.startsWith("<")) continue;
                    int i1 = element.indexOf(40);
                    String name = element.substring(0, i1);
                    String params = element.substring(i1 + 1, element.indexOf(")"));
                    String paramsDescriptor = "";
                    if (params.length() != 0) {
                        paramsDescriptor = "_" + params.replace(JavaCodeSerializer1.dotSeparator, "_").replace(", ", JavaCodeSerializer1.doubleSeparator).replace("[]", JavaCodeSerializer1.arrayDescriptor);
                    }
                    String normalized = name + paramsDescriptor;
                    this.methods.put((Object)name, (Object)normalized);
                    continue;
                }
                if (Utils.isEmpty(element)) continue;
                this.fields.add(element);
            }
            this.elements = Lists.newArrayList();
            this.elements.addAll(this.fields);
            for (String k : this.methods.keySet()) {
                if (!this.elements.contains(k)) {
                    this.elements.add(k);
                    continue;
                }
                ArrayList strings = Lists.newArrayList((Iterable)this.methods.get((Object)k));
                Collections.sort(strings);
                for (String string : strings) {
                    this.elements.add(JavaCodeSerializer1.this.name(string, this.elements, 0));
                }
            }
            for (Map.Entry entry : this.methods.entries()) {
            }
        }
    }

    private static class Writer {
        StringBuilder sb = new StringBuilder();
        int indent = 0;

        private Writer() {
        }

        public Writer append(String s) {
            this.sb.append(s);
            return this;
        }

        public Writer indentRight() {
            return this.append(Utils.repeat("\t", ++this.indent));
        }

        public Writer indentLeft() {
            return this.append(Utils.repeat("\t", --this.indent));
        }

        public Writer indent() {
            return this.append(Utils.repeat("\t", this.indent));
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

