/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListCDNContainerOptions
extends BaseHttpRequestOptions {
    public ListCDNContainerOptions limit(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public ListCDNContainerOptions marker(String marker) {
        this.queryParameters.put((Object)"marker", Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public ListCDNContainerOptions endMarker(String endMarker) {
        this.queryParameters.put((Object)"end_marker", Preconditions.checkNotNull((Object)endMarker, (Object)"endMarker"));
        return this;
    }

    public static class Builder {
        public static ListCDNContainerOptions limit(int limit) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.limit(limit);
        }

        public static ListCDNContainerOptions marker(String marker) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.marker(marker);
        }

        public static ListCDNContainerOptions endMarker(String endMarker) {
            ListCDNContainerOptions options = new ListCDNContainerOptions();
            return options.endMarker(endMarker);
        }
    }
}

