/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BasicBrooklynTypeRegistry;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.QuotedStringTokenizer;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleUpgradeParser {
    private static final Logger log = LoggerFactory.getLogger(BundleUpgradeParser.class);
    @Beta
    public static final String MANIFEST_HEADER_FORCE_REMOVE_LEGACY_ITEMS = "Brooklyn-Catalog-Force-Remove-Legacy-Items";
    @Beta
    public static final String MANIFEST_HEADER_FORCE_REMOVE_BUNDLES = "Brooklyn-Catalog-Force-Remove-Bundles";
    @Beta
    public static final String MANIFEST_HEADER_UPGRADE_FOR_BUNDLES = "Brooklyn-Catalog-Upgrade-For-Bundles";
    @Beta
    public static final String MANIFEST_HEADER_UPGRADE_FOR_TYPES = "Brooklyn-Catalog-Upgrade-For-Types";

    public static CatalogUpgrades parseBundleManifestForCatalogUpgrades(Bundle bundle, Supplier<? extends Iterable<? extends RegisteredType>> typeSupplier) {
        Dictionary headers = bundle.getHeaders();
        String upgradesForBundlesHeader = (String)headers.get(MANIFEST_HEADER_UPGRADE_FOR_BUNDLES);
        Multimap<VersionedName, VersionRangedName> upgradesForBundles = BundleUpgradeParser.parseUpgradeForBundlesHeader(upgradesForBundlesHeader, bundle);
        return CatalogUpgrades.builder().removedLegacyItems(BundleUpgradeParser.parseForceRemoveLegacyItemsHeader((String)headers.get(MANIFEST_HEADER_FORCE_REMOVE_LEGACY_ITEMS), bundle, typeSupplier)).removedBundles(BundleUpgradeParser.parseForceRemoveBundlesHeader((String)headers.get(MANIFEST_HEADER_FORCE_REMOVE_BUNDLES), bundle)).upgradeBundles(upgradesForBundles).upgradeTypes(BundleUpgradeParser.parseUpgradeForTypesHeader((String)headers.get(MANIFEST_HEADER_UPGRADE_FOR_TYPES), bundle, typeSupplier, upgradesForBundlesHeader == null ? null : upgradesForBundles)).build();
    }

    @VisibleForTesting
    static List<VersionRangedName> parseForceRemoveLegacyItemsHeader(String input, Bundle bundle, Supplier<? extends Iterable<? extends RegisteredType>> typeSupplier) {
        return BundleUpgradeParser.parseVersionRangedNameList(input, false, BundleUpgradeParser.getTypeNamesInBundle(typeSupplier), "[0," + bundle.getVersion() + ")");
    }

    @VisibleForTesting
    static List<VersionRangedName> parseForceRemoveBundlesHeader(String input, Bundle bundle) {
        if (input == null) {
            return ImmutableList.of();
        }
        return BundleUpgradeParser.parseVersionRangedNameList(input, false, (List<String>)MutableList.of((Object)bundle.getSymbolicName()), BundleUpgradeParser.getDefaultSourceVersionRange(bundle));
    }

    private static Multimap<VersionedName, VersionRangedName> parseUpgradeForBundlesHeader(String input, Bundle bundle) {
        return BundleUpgradeParser.parseVersionRangedNameEqualsVersionedNameList(input, false, (List<String>)MutableList.of((Object)bundle.getSymbolicName()), (List<String>)MutableList.of((Object)BundleUpgradeParser.getDefaultSourceVersionRange(bundle)), (Function<VersionRangedName, VersionedName>)((Function)i -> new VersionedName(bundle)));
    }

    private static Multimap<VersionedName, VersionRangedName> parseUpgradeForTypesHeader(String input, Bundle bundle, Supplier<? extends Iterable<? extends RegisteredType>> typeSupplier, Multimap<VersionedName, VersionRangedName> upgradesForBundles) {
        Collection acceptableRanges;
        List sourceVersions = null;
        if (upgradesForBundles != null && (acceptableRanges = upgradesForBundles.get((Object)new VersionedName(bundle))) != null && !acceptableRanges.isEmpty()) {
            for (VersionRangedName n : acceptableRanges) {
                if (!n.getSymbolicName().equals(bundle.getSymbolicName())) continue;
                if (sourceVersions == null) {
                    sourceVersions = MutableList.of();
                }
                sourceVersions.add(n.getOsgiVersionRange().toString());
            }
        }
        Set typeSupplierNames = MutableList.copyOf((Iterable)((Iterable)typeSupplier.get())).stream().map(t -> VersionedName.toOsgiVersionedName((VersionedName)t.getVersionedName())).collect(Collectors.toSet());
        if (input == null && sourceVersions != null && !sourceVersions.isEmpty()) {
            input = "*";
        }
        return BundleUpgradeParser.parseVersionRangedNameEqualsVersionedNameList(input, false, BundleUpgradeParser.getTypeNamesInBundle(typeSupplier), sourceVersions, (Function<VersionRangedName, VersionedName>)((Function)i -> {
            VersionedName targetTypeAtBundleVersion = new VersionedName(i.getSymbolicName(), bundle.getVersion());
            if (!typeSupplierNames.contains(VersionedName.toOsgiVersionedName((VersionedName)targetTypeAtBundleVersion))) {
                throw new IllegalStateException("Bundle manifest declares it upgrades " + i + " but does not declare an explicit target and does not contain inferred target " + targetTypeAtBundleVersion);
            }
            return targetTypeAtBundleVersion;
        }));
    }

    @VisibleForTesting
    static List<String> getTypeNamesInBundle(Supplier<? extends Iterable<? extends RegisteredType>> typeSupplier) {
        MutableList wildcardItems = MutableList.of();
        for (RegisteredType item : (Iterable)typeSupplier.get()) {
            wildcardItems.add(item.getSymbolicName());
        }
        return wildcardItems;
    }

    @VisibleForTesting
    static String getDefaultSourceVersionRange(Bundle bundle) {
        String bundleVersion = bundle.getVersion().toString();
        String maxVersion = BrooklynVersionSyntax.isSnapshot((String)bundleVersion) ? BrooklynVersionSyntax.stripSnapshot((String)bundleVersion) : bundleVersion;
        String defaultSourceVersion = "[0," + maxVersion + ")";
        return defaultSourceVersion;
    }

    @VisibleForTesting
    static List<VersionRangedName> parseVersionRangedNameList(String input, boolean singleVersionIsOsgiRange, List<String> wildcardNames, String wildcardVersion) {
        if (input == null) {
            return ImmutableList.of();
        }
        List vals = QuotedStringTokenizer.builder().delimiterChars(",").includeQuotes(false).includeDelimiters(false).buildList(input);
        ArrayList<VersionRangedName> versionedItems = new ArrayList<VersionRangedName>();
        for (String val : vals) {
            if ((val = val.trim()).startsWith("*")) {
                String r;
                if ("*".equals(val)) {
                    r = wildcardVersion;
                } else if (val.startsWith("*:")) {
                    r = val.substring(2);
                } else {
                    throw new IllegalArgumentException("Wildcard entry must be of the form \"*\" or \"*:range\"");
                }
                for (String item : wildcardNames) {
                    versionedItems.add(BundleUpgradeParser.parseVersionRangedName(item, r, false));
                }
                continue;
            }
            versionedItems.add(BundleUpgradeParser.parseVersionRangedName(val, singleVersionIsOsgiRange));
        }
        return versionedItems;
    }

    private static VersionRangedName parseVersionRangedName(String val, boolean singleVersionIsOsgiRange) {
        try {
            return VersionRangedName.fromString(val, singleVersionIsOsgiRange);
        }
        catch (Exception e) {
            if (Strings.containsAny((CharSequence)val, (CharSequence[])new CharSequence[]{"(", ")", "[", "]"}) && !Strings.containsAny((CharSequence)val, (CharSequence[])new CharSequence[]{"'", "\""})) {
                throw Exceptions.propagateAnnotated((String)"Entry cannot be parsed. If defining a range on an entry you must quote the entry.", (Throwable)e);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static VersionRangedName parseVersionRangedName(String name, String range, boolean singleVersionIsOsgiRange) {
        try {
            return new VersionRangedName(name, range, singleVersionIsOsgiRange);
        }
        catch (Exception e) {
            if (Strings.containsAny((CharSequence)range, (CharSequence[])new CharSequence[]{"(", ")", "[", "]"}) && !Strings.containsAny((CharSequence)range, (CharSequence[])new CharSequence[]{"'", "\""})) {
                throw Exceptions.propagateAnnotated((String)"Entry cannot be parsed. If defining a range on an entry you must quote the entry.", (Throwable)e);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    static Multimap<VersionedName, VersionRangedName> parseVersionRangedNameEqualsVersionedNameList(String input, boolean singleVersionIsOsgiRange, List<String> wildcardNames, List<String> wildcardVersions, Function<VersionRangedName, VersionedName> defaultTargetFunction) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (input == null) {
            return result;
        }
        List vals = QuotedStringTokenizer.builder().delimiterChars(",").includeQuotes(false).includeDelimiters(false).buildList(input);
        for (String entry : vals) {
            MutableList sourceNames;
            MutableList sourceVersions;
            String val;
            String key;
            String[] keVals = (entry = entry.trim()).split("=");
            if (keVals.length > 2) {
                throw new IllegalArgumentException("Max one = permitted in entry (\"" + entry + "\"). If defining a range on an entry you must quote the entry.");
            }
            if (keVals.length == 2) {
                key = keVals[0];
                val = keVals[1];
            } else {
                key = keVals[0];
                val = null;
            }
            if (key.startsWith("*")) {
                if (wildcardNames == null) {
                    throw new IllegalArgumentException("Wildcard cannot be inferred");
                }
                if ("*".equals(key)) {
                    if (wildcardVersions == null) {
                        throw new IllegalArgumentException("Version for wildcard cannot be inferred");
                    }
                    sourceVersions = wildcardVersions;
                } else if (key.startsWith("*:")) {
                    sourceVersions = MutableList.of((Object)key.substring(2));
                } else {
                    throw new IllegalArgumentException("Wildcard entry key must be of the form \"*\" or \"*:range\"");
                }
                sourceNames = MutableList.copyOf(wildcardNames);
            } else {
                String[] parts = key.split(":");
                if (parts.length == 1) {
                    if (wildcardVersions == null) {
                        throw new IllegalArgumentException("Version for " + key + " cannot be inferred");
                    }
                    sourceNames = MutableList.of((Object)key);
                    sourceVersions = wildcardVersions;
                } else if (parts.length == 2) {
                    sourceNames = MutableList.of((Object)parts[0]);
                    sourceVersions = MutableList.of((Object)parts[1]);
                } else {
                    throw new IllegalArgumentException("Entry '" + entry + "' should be of form 'name[:versionRange][=name[:version]]'");
                }
            }
            for (String item : sourceNames) {
                for (String v : sourceVersions) {
                    VersionedName target;
                    VersionRangedName source = BundleUpgradeParser.parseVersionRangedName(item, v, false);
                    if (val != null) {
                        target = VersionedName.fromString((String)val);
                    } else if (defaultTargetFunction != null) {
                        target = (VersionedName)defaultTargetFunction.apply((Object)source);
                    } else {
                        throw new IllegalArgumentException("Wildcard entry key must be of the form \"*\" or \"*:range\"");
                    }
                    result.put((Object)target, (Object)source);
                }
            }
        }
        return result;
    }

    @VisibleForTesting
    static String stripQuotes(String input) {
        String quoteChars = QuotedStringTokenizer.DEFAULT_QUOTE_CHARS;
        boolean quoted = input.length() >= 2 && quoteChars.contains(input.substring(0, 1)) && quoteChars.contains(input.substring(input.length() - 1));
        return quoted ? input.substring(1, input.length() - 1) : input;
    }

    public static class VersionRangedName {
        private final String name;
        private final String v;
        private volatile transient VersionRange cachedOsgiVersionRange;

        public static VersionRangedName fromString(String val, boolean singleVersionIsOsgiRange) {
            if (Strings.isBlank((CharSequence)val)) {
                throw new IllegalArgumentException("Must not be blank");
            }
            String[] parts = val.split(":");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Identifier '" + val + "' has too many parts; max one ':' symbol");
            }
            if (parts.length == 1 || Strings.isBlank((CharSequence)parts[1])) {
                throw new IllegalArgumentException("Identifier '" + val + "' must be of 'name:versionRange' syntax");
            }
            return new VersionRangedName(parts[0], parts[1], singleVersionIsOsgiRange);
        }

        protected static String tidyVersionRange(String v, boolean singleVersionIsOsgiRange) {
            if (v == null) {
                return null;
            }
            if (singleVersionIsOsgiRange || v.startsWith("(") || v.startsWith("[")) {
                return v;
            }
            return "[" + v + "," + v + "]";
        }

        public VersionRangedName(String name, VersionRange v) {
            this.name = ((String)Preconditions.checkNotNull((Object)name, (Object)"name")).toString();
            this.v = ((VersionRange)Preconditions.checkNotNull((Object)v, (Object)"versionRange")).toString();
        }

        private VersionRangedName(String name, String v, boolean singleVersionIsOsgiRange) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.v = VersionRangedName.tidyVersionRange((String)Preconditions.checkNotNull((Object)v, (Object)"versionRange"), singleVersionIsOsgiRange);
        }

        public String toString() {
            return this.name + ":" + this.v;
        }

        public String toOsgiString() {
            return this.name + ":" + this.getOsgiVersionRange();
        }

        public String getSymbolicName() {
            return this.name;
        }

        public VersionRange getOsgiVersionRange() {
            if (this.cachedOsgiVersionRange == null) {
                this.cachedOsgiVersionRange = VersionRange.valueOf((String)BrooklynVersionSyntax.toValidOsgiVersionRange((String)this.v));
            }
            return this.cachedOsgiVersionRange;
        }

        public String getVersionString() {
            return this.v;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.v});
        }

        public boolean equals(Object other) {
            if (!(other instanceof VersionRangedName)) {
                return false;
            }
            VersionRangedName o = (VersionRangedName)other;
            return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.v, (Object)o.v);
        }
    }

    public static class CatalogUpgrades {
        public static final CatalogUpgrades EMPTY = new CatalogUpgrades(CatalogUpgrades.builder());
        private final Set<VersionRangedName> removedLegacyItems;
        private final Set<VersionRangedName> removedBundles;
        private final Multimap<VersionedName, VersionRangedName> upgradesProvidedByBundles;
        private final Multimap<VersionedName, VersionRangedName> upgradesProvidedByTypes;

        public static Builder builder() {
            return new Builder();
        }

        public CatalogUpgrades(Builder builder) {
            this.removedLegacyItems = ImmutableSet.copyOf((Collection)builder.removedLegacyItems);
            this.removedBundles = ImmutableSet.copyOf((Collection)builder.removedBundles);
            this.upgradesProvidedByBundles = ImmutableMultimap.copyOf((Multimap)builder.upgradesProvidedByBundles);
            this.upgradesProvidedByTypes = ImmutableMultimap.copyOf((Multimap)builder.upgradesProvidedByTypes);
        }

        public boolean isEmpty() {
            return this.removedLegacyItems.isEmpty() && this.removedBundles.isEmpty() && this.upgradesProvidedByBundles.isEmpty() && this.upgradesProvidedByTypes.isEmpty();
        }

        public Set<VersionRangedName> getRemovedLegacyItems() {
            return this.removedLegacyItems;
        }

        public Set<VersionRangedName> getRemovedBundles() {
            return this.removedBundles;
        }

        public Multimap<VersionedName, VersionRangedName> getUpgradesProvidedByBundles() {
            return this.upgradesProvidedByBundles;
        }

        public Multimap<VersionedName, VersionRangedName> getUpgradesProvidedByTypes() {
            return this.upgradesProvidedByTypes;
        }

        public boolean isLegacyItemRemoved(CatalogItem<?, ?> legacyCatalogItem) {
            VersionedName name = new VersionedName(legacyCatalogItem.getSymbolicName(), legacyCatalogItem.getVersion());
            return CatalogUpgrades.contains(this.removedLegacyItems, name);
        }

        public boolean isBundleRemoved(VersionedName bundle) {
            return CatalogUpgrades.contains(this.removedBundles, bundle);
        }

        public Set<VersionedName> getUpgradesForBundle(VersionedName bundle) {
            return CatalogUpgrades.findUpgradesIn(bundle, this.upgradesProvidedByBundles);
        }

        public Set<VersionedName> getUpgradesForType(VersionedName type) {
            return CatalogUpgrades.findUpgradesIn(type, this.upgradesProvidedByTypes);
        }

        private static Set<VersionedName> findUpgradesIn(VersionedName item, Multimap<VersionedName, VersionRangedName> upgradesMap) {
            TreeSet<VersionedName> result = new TreeSet<VersionedName>((Comparator<VersionedName>)VersionedName.VersionedNameComparator.INSTANCE);
            for (Map.Entry n : upgradesMap.entries()) {
                if (!CatalogUpgrades.contains((VersionRangedName)n.getValue(), item)) continue;
                result.add((VersionedName)n.getKey());
            }
            return result;
        }

        @Beta
        public static boolean contains(Iterable<VersionRangedName> names, VersionedName name) {
            for (VersionRangedName contender : names) {
                if (!CatalogUpgrades.contains(contender, name)) continue;
                return true;
            }
            return false;
        }

        @Beta
        public static boolean contains(VersionRangedName range, VersionedName name) {
            return range.getSymbolicName().equals(name.getSymbolicName()) && range.getOsgiVersionRange().includes(name.getOsgiVersion());
        }

        @Beta
        public static void storeInManagementContext(CatalogUpgrades catalogUpgrades, ManagementContext managementContext) {
            ((BasicBrooklynTypeRegistry)managementContext.getTypeRegistry()).storeCatalogUpgradesInstructions(catalogUpgrades);
        }

        @Nonnull
        @Beta
        public static CatalogUpgrades getFromManagementContext(ManagementContext managementContext) {
            CatalogUpgrades result = ((BasicBrooklynTypeRegistry)managementContext.getTypeRegistry()).getCatalogUpgradesInstructions();
            if (result != null) {
                return result;
            }
            return CatalogUpgrades.builder().build();
        }

        @Beta
        public static Maybe<VersionedName> tryGetBundleForcedReplaced(ManagementContext mgmt, VersionedName vName) {
            if (vName == null || mgmt == null) {
                return Maybe.absent();
            }
            Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
            if (osgi.isAbsent()) {
                return Maybe.absent();
            }
            CatalogUpgrades cu = CatalogUpgrades.getFromManagementContext(mgmt);
            if (!cu.isBundleRemoved(vName)) {
                return Maybe.absent();
            }
            Set<VersionedName> upgrades = cu.getUpgradesForBundle(vName);
            if (upgrades.isEmpty()) {
                return Maybe.of((Object)null);
            }
            return Maybe.of((Object)upgrades.iterator().next());
        }

        @Beta
        public static String getBundleUpgradedIfNecessary(ManagementContext mgmt, String vName) {
            if (vName == null || mgmt == null) {
                return null;
            }
            Maybe<OsgiManager> osgi = ((ManagementContextInternal)mgmt).getOsgiManager();
            if (osgi.isAbsent()) {
                return vName;
            }
            if (((OsgiManager)osgi.get()).getManagedBundle(VersionedName.fromString((String)vName)) != null) {
                return vName;
            }
            return CatalogUpgrades.getItemUpgradedIfNecessary(mgmt, vName, (cu, vn) -> cu.getUpgradesForBundle(vn));
        }

        @Beta
        public static String getTypeUpgradedIfNecessary(ManagementContext mgmt, String vName) {
            if (vName == null || mgmt.getTypeRegistry().get(vName) != null) {
                return vName;
            }
            return CatalogUpgrades.getItemUpgradedIfNecessary(mgmt, vName, (cu, vn) -> cu.getUpgradesForType(vn));
        }

        private static String getItemUpgradedIfNecessary(ManagementContext mgmt, String vName, LookupFunction lookupF) {
            Set<VersionedName> r = lookupF.lookup(CatalogUpgrades.getFromManagementContext(mgmt), VersionedName.fromString((String)vName));
            if (!r.isEmpty()) {
                return r.iterator().next().toString();
            }
            if (log.isTraceEnabled()) {
                log.trace("Could not find '" + vName + "' and no upgrades specified; subsequent failure or warning possible unless that is a direct java class reference");
            }
            return vName;
        }

        @Beta
        public static boolean markerForCodeThatLoadsJavaTypesButShouldLoadRegisteredType() {
            return false;
        }

        @Beta
        CatalogUpgrades withUpgradesProvidedByTypeCleared(VersionedName versionedName) {
            return CatalogUpgrades.builder().addAll(this).clearUpgradesProvidedByType(versionedName).build();
        }

        @Beta
        CatalogUpgrades withUpgradesProvidedByBundleCleared(VersionedName versionedName) {
            return CatalogUpgrades.builder().addAll(this).clearUpgradesProvidedByBundle(versionedName).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Beta
        public static void clearTypeInStoredUpgrades(ManagementContext mgmt, VersionedName versionedName) {
            BrooklynTypeRegistry brooklynTypeRegistry = mgmt.getTypeRegistry();
            synchronized (brooklynTypeRegistry) {
                CatalogUpgrades.storeInManagementContext(CatalogUpgrades.getFromManagementContext(mgmt).withUpgradesProvidedByTypeCleared(versionedName), mgmt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Beta
        public static void clearBundleInStoredUpgrades(ManagementContext mgmt, VersionedName versionedName) {
            BrooklynTypeRegistry brooklynTypeRegistry = mgmt.getTypeRegistry();
            synchronized (brooklynTypeRegistry) {
                CatalogUpgrades.storeInManagementContext(CatalogUpgrades.getFromManagementContext(mgmt).withUpgradesProvidedByBundleCleared(versionedName), mgmt);
            }
        }

        private static interface LookupFunction {
            public Set<VersionedName> lookup(CatalogUpgrades var1, VersionedName var2);
        }

        public static class Builder {
            private Set<VersionRangedName> removedLegacyItems = new LinkedHashSet<VersionRangedName>();
            private Set<VersionRangedName> removedBundles = new LinkedHashSet<VersionRangedName>();
            private Multimap<VersionedName, VersionRangedName> upgradesProvidedByBundles = LinkedHashMultimap.create();
            private Multimap<VersionedName, VersionRangedName> upgradesProvidedByTypes = LinkedHashMultimap.create();

            public Builder removedLegacyItems(Collection<VersionRangedName> vals) {
                this.removedLegacyItems.addAll(vals);
                return this;
            }

            public Builder removedBundles(Collection<VersionRangedName> vals) {
                this.removedBundles.addAll(vals);
                return this;
            }

            public Builder upgradeBundles(Multimap<VersionedName, VersionRangedName> vals) {
                this.upgradesProvidedByBundles.putAll(vals);
                return this;
            }

            public Builder upgradeTypes(Multimap<VersionedName, VersionRangedName> vals) {
                this.upgradesProvidedByTypes.putAll(vals);
                return this;
            }

            public Builder addAll(CatalogUpgrades other) {
                this.removedLegacyItems.addAll(other.removedLegacyItems);
                this.removedBundles.addAll(other.removedBundles);
                this.upgradesProvidedByBundles.putAll(other.upgradesProvidedByBundles);
                this.upgradesProvidedByTypes.putAll(other.upgradesProvidedByTypes);
                return this;
            }

            public CatalogUpgrades build() {
                return new CatalogUpgrades(this);
            }

            public Builder clearUpgradesProvidedByType(VersionedName versionedName) {
                this.upgradesProvidedByTypes.removeAll((Object)versionedName);
                return this;
            }

            public Builder clearUpgradesProvidedByBundle(VersionedName versionedName) {
                this.upgradesProvidedByBundles.removeAll((Object)versionedName);
                return this;
            }
        }
    }
}

