/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.config;

import com.google.common.base.Function;
import com.google.inject.TypeLiteral;
import java.net.URI;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.options.ImageListOptions;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.functions.LinkToImageListOptions;
import org.jclouds.digitalocean2.functions.LinkToListOptions;
import org.jclouds.digitalocean2.handlers.DigitalOcean2ErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class DigitalOcean2HttpApiModule
extends HttpApiModule<DigitalOcean2Api> {
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(DigitalOcean2ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(DigitalOcean2ErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(DigitalOcean2ErrorHandler.class);
    }

    protected void configure() {
        super.configure();
        this.bind(OAuthScopes.class).toInstance((Object)OAuthScopes.ReadOrWriteScopes.create((String)"read", (String)"read write"));
        this.bind((TypeLiteral)new TypeLiteral<Function<URI, ListOptions>>(){}).to(LinkToListOptions.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<URI, ImageListOptions>>(){}).to(LinkToImageListOptions.class);
    }
}

