/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationDefinition;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.rest.api.LocationApi;
import org.apache.brooklyn.rest.domain.LocationSpec;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.LocationTransformer;
import org.apache.brooklyn.rest.util.EntityLocationUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class LocationResource
extends AbstractBrooklynRestResource
implements LocationApi {
    private static final Logger log = LoggerFactory.getLogger(LocationResource.class);
    private final Set<String> specsWarnedOnException = Sets.newConcurrentHashSet();
    private static NaturalOrderComparator COMPARATOR = new NaturalOrderComparator();

    public List<LocationSummary> list() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_LOCATION, (Object)Entitlements.StringAndArgument.of((String)"list locations", (Object)"see"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see locations", Entitlements.getEntitlementContext().user());
        }
        Function<LocationDefinition, LocationSummary> transformer = new Function<LocationDefinition, LocationSummary>(){

            public LocationSummary apply(LocationDefinition l) {
                try {
                    return LocationTransformer.newInstance(LocationResource.this.mgmt(), l, LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET, LocationResource.this.ui.getBaseUriBuilder());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    String spec = l.getSpec();
                    if (spec == null || LocationResource.this.specsWarnedOnException.add(spec)) {
                        log.warn("Unable to find details of location {} in REST call to list (ignoring location): {}", (Object)l, (Object)e);
                        if (log.isDebugEnabled()) {
                            log.debug("Error details for location " + l, (Throwable)e);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace("Unable again to find details of location {} in REST call to list (ignoring location): {}", (Object)l, (Object)e);
                    }
                    return null;
                }
            }
        };
        return FluentIterable.from(this.brooklyn().getLocationRegistry().getDefinedLocations(true).values()).transform((Function)transformer).filter(LocationSummary.class).toSortedList(LocationResource.nameOrSpecComparator());
    }

    private static Comparator<LocationSummary> nameOrSpecComparator() {
        return new Comparator<LocationSummary>(){

            @Override
            public int compare(LocationSummary o1, LocationSummary o2) {
                return COMPARATOR.compare(LocationResource.getNameOrSpec(o1).toLowerCase(), LocationResource.getNameOrSpec(o2).toLowerCase());
            }
        };
    }

    private static String getNameOrSpec(LocationSummary o) {
        if (Strings.isNonBlank((CharSequence)o.getName())) {
            return o.getName();
        }
        if (Strings.isNonBlank((CharSequence)o.getSpec())) {
            return o.getSpec();
        }
        return o.getId();
    }

    public Map<String, Map<String, Object>> getLocatedLocations() {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_LOCATION, (Object)Entitlements.StringAndArgument.of((String)"Get Located Locations", (Object)"see"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see locations", Entitlements.getEntitlementContext().user());
        }
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        Map<Location, Integer> counts = new EntityLocationUtils(this.mgmt()).countLeafEntitiesByLocatedLocations();
        for (Map.Entry<Location, Integer> count : counts.entrySet()) {
            Location l = count.getKey();
            MutableMap m = MutableMap.of((Object)"id", (Object)l.getId(), (Object)"name", (Object)l.getDisplayName(), (Object)"leafEntityCount", (Object)count.getValue(), (Object)"latitude", (Object)l.getConfig(LocationConfigKeys.LATITUDE), (Object)"longitude", (Object)l.getConfig(LocationConfigKeys.LONGITUDE));
            result.put(l.getId(), (Map<String, Object>)m);
        }
        return result;
    }

    public LocationSummary get(String locationId, String fullConfig) {
        return this.get(locationId, Boolean.valueOf(fullConfig));
    }

    public LocationSummary get(String locationId, boolean fullConfig) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_LOCATION, (Object)Entitlements.StringAndArgument.of((String)(locationId + "| fullConfig: " + fullConfig), (Object)"see"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see the location '%s'", Entitlements.getEntitlementContext().user(), locationId);
        }
        LocationTransformer.LocationDetailLevel configLevel = fullConfig ? LocationTransformer.LocationDetailLevel.FULL_EXCLUDING_SECRET : LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET;
        LocationSummary result = LocationTransformer.newInstance(this.mgmt(), locationId, configLevel, this.ui.getBaseUriBuilder());
        if (result != null) {
            return result;
        }
        throw WebResourceUtils.notFound("No location matching %s", locationId);
    }

    public Response create(LocationSpec locationSpec) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_LOCATION, (Object)Entitlements.StringAndArgument.of((String)locationSpec.toString(), (Object)"create"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add locations", Entitlements.getEntitlementContext().user());
        }
        String name = locationSpec.getName();
        ImmutableList.Builder yaml = ImmutableList.builder().add((Object[])new String[]{"brooklyn.catalog:", "  id: " + name, "  itemType: location", "  item:", "    type: " + locationSpec.getSpec()});
        if (locationSpec.getConfig().size() > 0) {
            yaml.add((Object)"    brooklyn.config:");
            for (Map.Entry entry : locationSpec.getConfig().entrySet()) {
                yaml.add((Object)("      " + (String)entry.getKey() + ": " + entry.getValue()));
            }
        }
        String locationBlueprint = Joiner.on((String)"\n").join((Iterable)yaml.build());
        this.brooklyn().getCatalog().addItems(locationBlueprint);
        LocationDefinition l = this.brooklyn().getLocationRegistry().getDefinedLocationByName(name);
        URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(this.ui.getBaseUriBuilder(), LocationApi.class, "get").build(new Object[]{name});
        return Response.created((URI)ref).entity((Object)LocationTransformer.newInstance(this.mgmt(), l, LocationTransformer.LocationDetailLevel.LOCAL_EXCLUDING_SECRET, this.ui.getBaseUriBuilder())).build();
    }

    @Deprecated
    public void delete(String locationId) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.DELETE_LOCATION, (Object)Entitlements.StringAndArgument.of((String)locationId, (Object)"delete"))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to delete locations", Entitlements.getEntitlementContext().user());
        }
        if (this.deleteAllVersions(locationId) > 0) {
            return;
        }
        throw WebResourceUtils.notFound("No catalog item location matching %s; only catalog item locations can be deleted", locationId);
    }

    private int deleteAllVersions(String locationId) {
        RegisteredType item = this.mgmt().getTypeRegistry().get(locationId);
        if (item == null) {
            return 0;
        }
        this.brooklyn().getCatalog().deleteCatalogItem(item.getSymbolicName(), item.getVersion());
        return 1 + this.deleteAllVersions(locationId);
    }
}

