/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.brooklyn.location.jclouds.AbstractComputeServiceRegistry;
import org.apache.brooklyn.location.jclouds.AwsEc2SessionAwareLocationConfig;
import org.apache.brooklyn.location.jclouds.ComputeServiceRegistry;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.compute.ComputeService;
import org.jclouds.domain.Credentials;

public class AwsEc2SessionAwareComputeServiceRegistry
extends AbstractComputeServiceRegistry
implements ComputeServiceRegistry,
AwsEc2SessionAwareLocationConfig {
    public static final String ACCESS_KEY_ID = "AccessKeyId";
    public static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    public static final String TOKEN = "Token";
    public static final String EXPIRATION = "Expiration";
    public static final String AWS_SECURITY_CREDENTIAL_URL = "http://169.254.169.254/latest/meta-data/iam/security-credentials";
    public static final String AWS_EXPIRATION_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Override
    public ComputeService findComputeService(ConfigBag conf, boolean allowReuse) {
        return super.findComputeService(conf, false);
    }

    @Override
    protected Supplier<Credentials> makeCredentials(ConfigBag conf) {
        String identity = null;
        String credential = null;
        String token = null;
        Date expiration = null;
        String provider = this.getProviderFromConfig(conf);
        String iamRoleName = this.getIamRoleNameFromConfig(conf);
        if ("aws-ec2".equals(provider)) {
            try {
                String instanceProfileUrl = AWS_SECURITY_CREDENTIAL_URL;
                JsonNode node = new ObjectMapper().readTree(new URL(instanceProfileUrl + "/" + iamRoleName));
                identity = node.path(ACCESS_KEY_ID).asText();
                credential = node.path(SECRET_ACCESS_KEY).asText();
                token = node.path(TOKEN).asText();
                expiration = new SimpleDateFormat(AWS_EXPIRATION_DATE_FORMAT).parse(node.path(EXPIRATION).asText());
            }
            catch (IOException | ParseException e) {
                Exceptions.propagate((Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Provider " + provider + " does not support session credentials");
        }
        identity = (String)Preconditions.checkNotNull(identity, (Object)"identity must not be null");
        credential = (String)Preconditions.checkNotNull(credential, (Object)"credential must not be null");
        token = (String)Preconditions.checkNotNull(token, (Object)"token must not be null");
        SessionCredentials credentials = SessionCredentials.builder().accessKeyId(identity).credential(credential).sessionToken(token).expiration(expiration).build();
        return () -> AwsEc2SessionAwareComputeServiceRegistry.lambda$makeCredentials$0((Credentials)credentials);
    }

    private String getIamRoleNameFromConfig(ConfigBag conf) {
        return (String)Preconditions.checkNotNull((Object)conf.get(IAM_ROLE_NAME), (Object)"IAM role must not be null");
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    private static /* synthetic */ Credentials lambda$makeCredentials$0(Credentials credentials) {
        return credentials;
    }
}

