/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.entity.group.RemovalStrategy;

public class FirstFromRemovalStrategy
extends RemovalStrategy {
    public static final ConfigKey<List<RemovalStrategy>> STRATEGIES = ConfigKeys.newConfigKey(new TypeToken<List<RemovalStrategy>>(){}, "firstfrom.strategies", "An ordered list of removal strategies to be used to determine which entity to remove");

    @Nullable
    public Entity apply(@Nullable Collection<Entity> input) {
        List strategies = (List)this.config().get(STRATEGIES);
        if (strategies == null || Iterables.isEmpty((Iterable)strategies)) {
            return null;
        }
        for (RemovalStrategy strategy : strategies) {
            Entity entity = (Entity)strategy.apply(input);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }
}

