/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.brooklyn.core.mgmt.persist.FileBasedObjectStore;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.io.FileUtil;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedStoreObjectAccessor
implements PersistenceObjectStore.StoreObjectAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedStoreObjectAccessor.class);
    private final File file;
    private final File tmpFile;

    public FileBasedStoreObjectAccessor(File file, String tmpExtension) {
        this.file = file;
        this.tmpFile = new File(file.getParentFile(), file.getName() + (Strings.isBlank((CharSequence)tmpExtension) ? ".tmp" : tmpExtension));
    }

    @Override
    public String get() {
        try {
            if (!this.exists()) {
                return null;
            }
            return Files.asCharSource((File)this.file, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            throw Exceptions.propagateAnnotated((String)("Problem reading String contents of file " + this.file), (Throwable)e);
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            if (!this.exists()) {
                return null;
            }
            return Files.asByteSource((File)this.file).read();
        }
        catch (IOException e) {
            throw Exceptions.propagateAnnotated((String)("Problem reading bytes of file " + this.file), (Throwable)e);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void put(String val) {
        if (val == null) {
            val = "";
        }
        this.put(ByteSource.wrap((byte[])val.getBytes(Charsets.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ByteSource bytes) {
        try {
            FileUtil.setFilePermissionsTo600((File)this.tmpFile);
            FileOutputStream tempStream = new FileOutputStream(this.tmpFile);
            InputStream byteStream = bytes.openStream();
            try {
                Streams.copy((InputStream)byteStream, (OutputStream)tempStream);
                this.syncFileSystem(tempStream.getFD());
            }
            finally {
                Streams.closeQuietly((Closeable)byteStream);
                Streams.closeQuietly((Closeable)tempStream);
            }
            FileBasedObjectStore.moveFile(this.tmpFile, this.file);
        }
        catch (IOException e) {
            throw Exceptions.propagateAnnotated((String)("Problem writing data to file " + this.file + " (via temporary file " + this.tmpFile + ")"), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void syncFileSystem(FileDescriptor fd) throws SyncFailedException {
        int maxTries = 3;
        SyncFailedException sfe = null;
        for (int c = 0; c < maxTries; ++c) {
            try {
                fd.sync();
                sfe = null;
                break;
            }
            catch (SyncFailedException e) {
                sfe = e;
                continue;
            }
        }
        if (sfe != null) {
            throw sfe;
        }
    }

    @Override
    public void append(String val) {
        try {
            if (val == null) {
                val = "";
            }
            FileUtil.setFilePermissionsTo600((File)this.file);
            Files.append((CharSequence)val, (File)this.file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Exceptions.propagateAnnotated((String)("Problem appending to file " + this.file), (Throwable)e);
        }
    }

    @Override
    public void delete() {
        if (!this.file.delete()) {
            if (!this.file.exists()) {
                LOG.debug("Unable to delete " + this.file.getAbsolutePath() + ". Probably did not exist.");
            } else {
                LOG.warn("Unable to delete " + this.file.getAbsolutePath() + ". Probably still locked.");
            }
        }
        if (this.tmpFile.exists() && !this.tmpFile.delete()) {
            LOG.warn("Unable to delete " + this.tmpFile.getAbsolutePath() + ". Probably still locked.");
        }
    }

    @Override
    public Date getLastModifiedDate() {
        long result = this.file.lastModified();
        if (result == 0L) {
            return null;
        }
        return new Date(result);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("file", (Object)this.file).toString();
    }
}

