/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.riak;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.nosql.riak.RiakNode;
import org.apache.brooklyn.entity.nosql.riak.RiakNodeDriver;
import org.apache.brooklyn.entity.nosql.riak.RiakNodeImpl;
import org.apache.brooklyn.entity.software.base.lifecycle.ScriptHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiakNodeSshDriver
extends JavaSoftwareProcessSshDriver
implements RiakNodeDriver {
    private static final Logger LOG = LoggerFactory.getLogger(RiakNodeSshDriver.class);
    private static final String INSTALLING_FALLBACK = "installing_fallback";

    public RiakNodeSshDriver(RiakNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return "/var/log/riak/solr.log";
    }

    public RiakNodeImpl getEntity() {
        return (RiakNodeImpl)RiakNodeImpl.class.cast(super.getEntity());
    }

    public Map<String, String> getShellEnvironment() {
        MutableMap result = MutableMap.copyOf((Map)super.getShellEnvironment());
        if (this.getEntity().getEpmdListenerPort() != null) {
            result.put((Object)"ERL_EPMD_PORT", (Object)Integer.toString(this.getEntity().getEpmdListenerPort()));
        }
        result.put((Object)"WAIT_FOR_ERLANG", (Object)"60");
        return result;
    }

    public void prepare() {
        super.prepare();
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        if (osDetails.isLinux()) {
            this.entity.sensors().set(RiakNode.RIAK_PACKAGE_INSTALL, (Object)true);
        } else if (osDetails.isMac()) {
            this.entity.sensors().set(RiakNode.RIAK_PACKAGE_INSTALL, (Object)false);
        }
    }

    public void install() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        LinkedList commands = Lists.newLinkedList();
        if (osDetails.isLinux()) {
            if (this.getEntity().isPackageDownloadUrlProvided()) {
                commands.addAll(this.installLinuxFromPackageUrl());
            } else {
                commands.addAll(this.installFromPackageCloud());
            }
        } else if (osDetails.isMac()) {
            commands.addAll(this.installMac());
        } else {
            if (osDetails.isWindows()) {
                throw new UnsupportedOperationException("RiakNode not supported on Windows instances");
            }
            throw new IllegalStateException("Machine was not detected as linux, mac or windows! Installation does not know how to proceed with " + this.getMachine() + ". Details: " + this.getMachine().getMachineDetails().getOsDetails());
        }
        LOG.debug("Installing to " + this + " using commands:\n" + Strings.join((Iterable)commands, (String)"\n"));
        int result = this.newScript((String)"installing").body.append((Collection)commands).failIfBodyEmpty().execute();
        if (result != 0 && osDetails.isLinux()) {
            result = this.newScript((String)INSTALLING_FALLBACK).body.append(this.installLinuxFromPackageUrl()).execute();
        }
        if (result != 0) {
            throw new IllegalStateException(String.format("Install failed with result %d", result));
        }
    }

    private List<String> installLinuxFromPackageUrl() {
        String osReleaseCmd;
        String downloadUrl;
        DynamicTasks.queueIfPossible((TaskFactory)SshTasks.dontRequireTtyForSudo((SshMachineLocation)this.getMachine(), (SshTasks.OnFailingTask)SshTasks.OnFailingTask.WARN_OR_IF_DYNAMIC_FAIL_MARKING_INESSENTIAL)).orSubmitAndBlock();
        String expandedInstallDir = this.getExpandedInstallDir();
        String installBin = Urls.mergePaths((String[])new String[]{expandedInstallDir, "bin"});
        String saveAsYum = "riak.rpm";
        String saveAsApt = "riak.deb";
        OsDetails osDetails = this.getMachine().getOsDetails();
        if ("debian".equalsIgnoreCase(osDetails.getName())) {
            downloadUrl = (String)this.entity.getAttribute(RiakNode.DOWNLOAD_URL_DEBIAN);
            osReleaseCmd = osDetails.getVersion().substring(0, osDetails.getVersion().indexOf("."));
        } else {
            downloadUrl = (String)this.entity.getAttribute(RiakNode.DOWNLOAD_URL_UBUNTU);
            osReleaseCmd = "`lsb_release -sc` && export OS_RELEASE=`([[ \"lucid natty precise\" =~ (^| )\\$OS_RELEASE($| ) ]] && echo $OS_RELEASE || echo precise)`";
        }
        String apt = BashCommands.chainGroup((String[])new String[]{BashCommands.addSbinPathCommand(), "which apt-get", BashCommands.ok((String)BashCommands.sudo((String)"apt-get -y --allow-unauthenticated install logrotate libpam0g-dev libssl0.9.8")), "export OS_NAME=" + Strings.toLowerCase((String)osDetails.getName()), "export OS_RELEASE=" + osReleaseCmd, String.format("curl %s -o %s", downloadUrl, saveAsApt), BashCommands.sudo((String)String.format("dpkg -i %s", saveAsApt))});
        String yum = BashCommands.chainGroup((String[])new String[]{"which yum", BashCommands.ok((String)BashCommands.sudo((String)"yum -y install openssl")), String.format("curl %s -o %s", this.entity.sensors().get(RiakNode.DOWNLOAD_URL_RHEL_CENTOS), saveAsYum), BashCommands.sudo((String)String.format("yum localinstall -y %s", saveAsYum))});
        return ImmutableList.builder().add((Object)("mkdir -p " + installBin)).add((Object)BashCommands.INSTALL_CURL).add((Object)BashCommands.alternatives((String[])new String[]{apt, yum})).add((Object)("ln -s `which riak` " + Urls.mergePaths((String[])new String[]{installBin, "riak"}))).add((Object)("ln -s `which riak-admin` " + Urls.mergePaths((String[])new String[]{installBin, "riak-admin"}))).build();
    }

    private List<String> installFromPackageCloud() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        return ImmutableList.builder().add((Object)(osDetails.getName().toLowerCase().contains("debian") ? BashCommands.addSbinPathCommand() : "")).add((Object)BashCommands.ifNotExecutable((String)"curl", (String)BashCommands.INSTALL_CURL)).addAll((Iterable)BashCommands.ifExecutableDoesNotExistElse((String)"yum", this.installDebianBased(), this.installRpmBased())).build();
    }

    private ImmutableList<String> installDebianBased() {
        return ImmutableList.builder().add((Object)("curl https://packagecloud.io/install/repositories/basho/riak/script.deb.sh | " + BashCommands.sudo((String)"bash"))).add((Object)BashCommands.sudo((String)("apt-get install --assume-yes riak=" + this.getEntity().getFullVersion() + "-1"))).build();
    }

    private ImmutableList<String> installRpmBased() {
        return ImmutableList.builder().add((Object)("curl https://packagecloud.io/install/repositories/basho/riak/script.rpm.sh | " + BashCommands.sudo((String)"bash"))).add((Object)BashCommands.sudo((String)("yum install -y riak-" + this.getEntity().getFullVersion() + "*"))).build();
    }

    protected List<String> installMac() {
        String saveAs = this.resolver.getFilename();
        String url = (String)this.entity.getAttribute(RiakNode.DOWNLOAD_URL_MAC);
        return ImmutableList.builder().add((Object)BashCommands.INSTALL_TAR).add((Object)BashCommands.INSTALL_CURL).add((Object)BashCommands.commandToDownloadUrlAs((String)url, (String)saveAs)).add((Object)("tar xzvf " + saveAs)).build();
    }

    public void customize() {
        this.checkRiakOnPath();
        this.newScript("customizing").execute();
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        LinkedList commands = Lists.newLinkedList();
        commands.add(BashCommands.sudo((String)("mkdir -p " + this.getRiakEtcDir())));
        if (this.isVersion1()) {
            String vmArgsTemplate = this.processTemplate((String)this.entity.getConfig(RiakNode.RIAK_VM_ARGS_TEMPLATE_URL));
            String saveAsVmArgs = Urls.mergePaths((String[])new String[]{this.getRunDir(), "vm.args"});
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)saveAsVmArgs).contents(vmArgsTemplate));
            commands.add(BashCommands.sudo((String)("mv " + saveAsVmArgs + " " + this.getRiakEtcDir())));
            String appConfigTemplate = this.processTemplate((String)this.entity.getConfig(RiakNode.RIAK_APP_CONFIG_TEMPLATE_URL));
            String saveAsAppConfig = Urls.mergePaths((String[])new String[]{this.getRunDir(), "app.config"});
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)saveAsAppConfig).contents(appConfigTemplate));
            commands.add(BashCommands.sudo((String)("mv " + saveAsAppConfig + " " + this.getRiakEtcDir())));
        } else {
            String templateUrl = osDetails.isMac() ? (String)this.entity.getConfig(RiakNode.RIAK_CONF_TEMPLATE_URL_MAC) : (String)this.entity.getConfig(RiakNode.RIAK_CONF_TEMPLATE_URL_LINUX);
            String riakConfContent = this.processTemplate(templateUrl);
            String saveAsRiakConf = Urls.mergePaths((String[])new String[]{this.getRunDir(), "riak.conf"});
            if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(RiakNode.RIAK_CONF_ADDITIONAL_CONTENT)))) {
                String additionalConfigContent = this.processTemplateContents((String)this.entity.getConfig(RiakNode.RIAK_CONF_ADDITIONAL_CONTENT));
                riakConfContent = riakConfContent + "\n## Brooklyn note: additional config\n";
                riakConfContent = riakConfContent + additionalConfigContent;
            }
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)saveAsRiakConf).contents(riakConfContent));
            commands.add(BashCommands.sudo((String)("mv " + saveAsRiakConf + " " + this.getRiakEtcDir())));
        }
        if (osDetails.isMac()) {
            commands.add("ulimit -n 4096");
        }
        if (osDetails.isLinux() && this.isVersion1()) {
            commands.add(BashCommands.sudo((String)("chown -R riak:riak " + this.getRiakEtcDir())));
        }
        ScriptHelper customizeScript = this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((Collection)commands);
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(customizeScript);
        }
        customizeScript.failOnNonZeroResultCode().execute();
        if (osDetails.isLinux()) {
            ImmutableMap sysctl = ImmutableMap.builder().put((Object)"vm.swappiness", (Object)"0").put((Object)"net.core.somaxconn", (Object)"40000").put((Object)"net.ipv4.tcp_max_syn_backlog", (Object)"40000").put((Object)"net.ipv4.tcp_sack", (Object)"1").put((Object)"net.ipv4.tcp_window_scaling", (Object)"15").put((Object)"net.ipv4.tcp_fin_timeout", (Object)"1").put((Object)"net.ipv4.tcp_keepalive_intvl", (Object)"30").put((Object)"net.ipv4.tcp_tw_reuse", (Object)"1").put((Object)"net.ipv4.tcp_moderate_rcvbuf", (Object)"1").build();
            ScriptHelper optimize = this.newScript((String)"customizingnetwork").body.append((CharSequence)BashCommands.sudo((String)("sysctl " + Joiner.on((char)' ').withKeyValueSeparator("=").join((Map)sysctl))));
            Optional enable = Optional.fromNullable((Object)this.entity.getConfig(RiakNode.OPTIMIZE_HOST_NETWORKING));
            if (!enable.isPresent()) {
                optimize.inessential();
            }
            if (((Boolean)enable.or((Object)true)).booleanValue()) {
                optimize.execute();
            }
        }
        this.entity.sensors().set(RiakNode.RIAK_NODE_NAME, (Object)String.format("riak@%s", this.getSubnetHostname()));
    }

    public void launch() {
        LinkedList commands = Lists.newLinkedList();
        if (this.isPackageInstall()) {
            commands.add(BashCommands.addSbinPathCommand());
            commands.add(BashCommands.sudo((String)String.format("sh -c \"ulimit -n %s && service riak start\"", this.maxOpenFiles())));
        } else {
            commands.add("ulimit -n 65536 || true");
            commands.add(String.format("%s start >/dev/null 2>&1 < /dev/null &", this.getRiakCmd()));
        }
        ScriptHelper launchScript = this.newScript((String)"launching").body.append((Collection)commands);
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(launchScript);
        }
        launchScript.failOnNonZeroResultCode().execute();
        String mainUri = String.format("http://%s:%s/admin", this.entity.getAttribute(Attributes.HOSTNAME), this.entity.getAttribute((AttributeSensor)RiakNode.RIAK_WEB_PORT));
        this.entity.sensors().set(Attributes.MAIN_URI, (Object)URI.create(mainUri));
    }

    public void stop() {
        int result;
        this.leaveCluster();
        String command = String.format("%s stop", this.getRiakCmd());
        command = this.isPackageInstall() ? BashCommands.sudo((String)command) : command;
        ScriptHelper stopScript = this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)command);
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(stopScript);
        }
        if ((result = stopScript.failOnNonZeroResultCode().execute()) != 0) {
            this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)false), "stopping").execute();
        }
    }

    public boolean isRunning() {
        ScriptHelper checkRunningScript = this.newScript((String)"check-running").body.append((CharSequence)BashCommands.sudo((String)String.format("%s ping", this.getRiakCmd())));
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(checkRunningScript);
        }
        return checkRunningScript.execute() == 0;
    }

    public boolean isPackageInstall() {
        return (Boolean)this.entity.getAttribute(RiakNode.RIAK_PACKAGE_INSTALL);
    }

    public boolean isRiakOnPath() {
        return (Boolean)this.entity.getAttribute(RiakNode.RIAK_ON_PATH);
    }

    @Override
    public String getRiakEtcDir() {
        return this.isPackageInstall() ? "/etc/riak" : Urls.mergePaths((String[])new String[]{this.getExpandedInstallDir(), "etc"});
    }

    protected String getRiakCmd() {
        return this.isPackageInstall() ? "riak" : Urls.mergePaths((String[])new String[]{this.getExpandedInstallDir(), "bin/riak"});
    }

    protected String getRiakAdminCmd() {
        return this.isPackageInstall() ? "riak-admin" : Urls.mergePaths((String[])new String[]{this.getExpandedInstallDir(), "bin/riak-admin"});
    }

    @Override
    public void joinCluster(String nodeName) {
        if (this.getRiakName().equals(nodeName)) {
            log.warn("Cannot join Riak node: {} to itself", (Object)nodeName);
        } else if (!this.hasJoinedCluster().booleanValue()) {
            ScriptHelper joinClusterScript = this.newScript((String)"joinCluster").body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster join %s", (Object[])new Object[]{this.getRiakAdminCmd(), nodeName}))).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster plan", (Object[])new Object[]{this.getRiakAdminCmd()}))).body.append((CharSequence)BashCommands.sudo((String)String.format("%s cluster commit", this.getRiakAdminCmd()))).failOnNonZeroResultCode();
            if (!this.isRiakOnPath()) {
                this.addRiakOnPath(joinClusterScript);
            }
            joinClusterScript.execute();
            this.entity.sensors().set(RiakNode.RIAK_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.TRUE);
        } else {
            log.warn("entity {}: is already in the riak cluster", (Object)this.entity.getId());
        }
    }

    @Override
    public void leaveCluster() {
        if (this.hasJoinedCluster().booleanValue()) {
            ScriptHelper leaveClusterScript = this.newScript((String)"leaveCluster").body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster leave", (Object[])new Object[]{this.getRiakAdminCmd()}))).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster plan", (Object[])new Object[]{this.getRiakAdminCmd()}))).body.append((CharSequence)BashCommands.sudo((String)String.format("%s cluster commit", this.getRiakAdminCmd()))).failOnNonZeroResultCode();
            if (!this.isRiakOnPath()) {
                this.addRiakOnPath(leaveClusterScript);
            }
            leaveClusterScript.execute();
            this.entity.sensors().set(RiakNode.RIAK_NODE_HAS_JOINED_CLUSTER, (Object)Boolean.FALSE);
        } else {
            log.warn("entity {}: has already left the riak cluster", (Object)this.entity.getId());
        }
    }

    @Override
    public void removeNode(String nodeName) {
        ScriptHelper removeNodeScript = this.newScript((String)"removeNode").body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster force-remove %s", (Object[])new Object[]{this.getRiakAdminCmd(), nodeName}))).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s down %s", (Object[])new Object[]{this.getRiakAdminCmd(), nodeName}))).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster plan", (Object[])new Object[]{this.getRiakAdminCmd()}))).body.append((CharSequence)BashCommands.sudo((String)String.format("%s cluster commit", this.getRiakAdminCmd()))).failOnNonZeroResultCode();
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(removeNodeScript);
        }
        removeNodeScript.execute();
    }

    @Override
    public void bucketTypeCreate(String bucketTypeName, String bucketTypeProperties) {
        ScriptHelper bucketTypeCreateScript = this.newScript((String)new StringBuilder().append((String)"bucket-type_create ").append((String)bucketTypeName).toString()).body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type create %s %s", this.getRiakAdminCmd(), bucketTypeName, StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)bucketTypeProperties))));
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(bucketTypeCreateScript);
        }
        bucketTypeCreateScript.body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type activate %s", this.getRiakAdminCmd(), bucketTypeName))).failOnNonZeroResultCode();
        bucketTypeCreateScript.execute();
    }

    @Override
    public List<String> bucketTypeList() {
        ScriptHelper bucketTypeListScript = this.newScript((String)"bucket-types_list").body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type list", this.getRiakAdminCmd()))).gatherOutput().noExtraOutput().failOnNonZeroResultCode();
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(bucketTypeListScript);
        }
        bucketTypeListScript.execute();
        String stdout = bucketTypeListScript.getResultStdout();
        return Arrays.asList(stdout.split("[\\r\\n]+"));
    }

    @Override
    public List<String> bucketTypeStatus(String bucketTypeName) {
        ScriptHelper bucketTypeStatusScript = this.newScript((String)"bucket-type_status").body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type status %s", this.getRiakAdminCmd(), bucketTypeName))).gatherOutput().noExtraOutput().failOnNonZeroResultCode();
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(bucketTypeStatusScript);
        }
        bucketTypeStatusScript.execute();
        String stdout = bucketTypeStatusScript.getResultStdout();
        return Arrays.asList(stdout.split("[\\r\\n]+"));
    }

    @Override
    public void bucketTypeUpdate(String bucketTypeName, String bucketTypeProperties) {
        ScriptHelper bucketTypeStatusScript = this.newScript((String)"bucket-type_update").body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type update %s %s", this.getRiakAdminCmd(), bucketTypeName, StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)bucketTypeProperties)))).failOnNonZeroResultCode();
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(bucketTypeStatusScript);
        }
        bucketTypeStatusScript.execute();
    }

    @Override
    public void bucketTypeActivate(String bucketTypeName) {
        ScriptHelper bucketTypeStatusScript = this.newScript((String)"bucket-type_activate").body.append((CharSequence)BashCommands.sudo((String)String.format("%s bucket-type activate %s", this.getRiakAdminCmd(), bucketTypeName))).failOnNonZeroResultCode();
        if (!this.isRiakOnPath()) {
            this.addRiakOnPath(bucketTypeStatusScript);
        }
        bucketTypeStatusScript.execute();
    }

    @Override
    public void recoverFailedNode(String nodeName) {
        if (this.hasJoinedCluster().booleanValue()) {
            String failedNodeName = this.getRiakName();
            String stopCommand = String.format("%s stop", this.getRiakCmd());
            stopCommand = this.isPackageInstall() ? BashCommands.sudo((String)stopCommand) : stopCommand;
            String startCommand = String.format("%s start > /dev/null 2>&1 < /dev/null &", this.getRiakCmd());
            startCommand = this.isPackageInstall() ? BashCommands.sudo((String)startCommand) : startCommand;
            ScriptHelper recoverNodeScript = this.newScript((String)"recoverNode").body.append((CharSequence)stopCommand).body.append((CharSequence)String.format((String)"%s down %s", (Object[])new Object[]{this.getRiakAdminCmd(), failedNodeName})).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"rm -rf %s", (Object[])new Object[]{this.getRingStateDir()}))).body.append((CharSequence)startCommand).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster join %s", (Object[])new Object[]{this.getRiakAdminCmd(), nodeName}))).body.append((CharSequence)BashCommands.sudo((String)String.format((String)"%s cluster plan", (Object[])new Object[]{this.getRiakAdminCmd()}))).body.append((CharSequence)BashCommands.sudo((String)String.format("%s cluster commit", this.getRiakAdminCmd()))).failOnNonZeroResultCode();
            if (!this.isRiakOnPath()) {
                this.addRiakOnPath(recoverNodeScript);
            }
            recoverNodeScript.execute();
        } else {
            log.warn("entity {}: is not in the riak cluster", (Object)this.entity.getId());
        }
    }

    public void setup() {
        if (((Boolean)this.entity.getConfig(RiakNode.SEARCH_ENABLED)).booleanValue()) {
            super.setup();
        }
    }

    private Boolean hasJoinedCluster() {
        return Boolean.TRUE.equals(this.entity.getAttribute(RiakNode.RIAK_NODE_HAS_JOINED_CLUSTER));
    }

    protected void checkRiakOnPath() {
        boolean riakOnPath = this.newScript((String)"riakOnPath").body.append((CharSequence)"which riak").execute() == 0;
        this.entity.sensors().set(RiakNode.RIAK_ON_PATH, (Object)riakOnPath);
    }

    private String getRiakName() {
        return (String)this.entity.getAttribute(RiakNode.RIAK_NODE_NAME);
    }

    private String getRingStateDir() {
        return this.isPackageInstall() ? "/var/lib/riak/ring" : Urls.mergePaths((String[])new String[]{this.getExpandedInstallDir(), "lib/ring"});
    }

    protected boolean isVersion1() {
        return this.getVersion().startsWith("1.");
    }

    @Override
    public String getOsMajorVersion() {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String osVersion = osDetails.getVersion();
        return osVersion.contains(".") ? osVersion.substring(0, osVersion.indexOf(".")) : osVersion;
    }

    private void addRiakOnPath(ScriptHelper scriptHelper) {
        ImmutableMap newPathVariable = ImmutableMap.of((Object)"PATH", (Object)BashCommands.sbinPath());
        scriptHelper.environmentVariablesReset((Map)newPathVariable);
    }

    public Integer maxOpenFiles() {
        return (Integer)this.entity.getConfig(RiakNode.RIAK_MAX_OPEN_FILES);
    }
}

