/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.features.KeyPairApi;
import org.jclouds.logging.Logger;

@Singleton
public class CreateUniqueKeyPair
implements Function<RegionAndName, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Api ec2Api;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public CreateUniqueKeyPair(EC2Api ec2Api, GroupNamingConvention.Factory namingConvention) {
        this.ec2Api = ec2Api;
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    public KeyPair apply(RegionAndName from) {
        return this.createNewKeyPairInRegion(from.getRegion(), from.getName());
    }

    @VisibleForTesting
    KeyPair createNewKeyPairInRegion(String region, String group) {
        Preconditions.checkNotNull((Object)region, (Object)"region");
        Preconditions.checkNotNull((Object)group, (Object)"group");
        this.logger.debug(">> creating keyPair region(%s) group(%s)", new Object[]{region, group});
        KeyPair keyPair = null;
        String prefix = group;
        while (keyPair == null) {
            String keyName = this.namingConvention.create().uniqueNameForGroup(prefix);
            try {
                keyPair = ((KeyPairApi)this.ec2Api.getKeyPairApi().get()).createKeyPairInRegion(region, keyName);
            }
            catch (IllegalStateException e) {
                this.logger.trace("   invalid keyname (%s in %s); retrying", new Object[]{keyName, region});
            }
        }
        this.logger.debug("<< created keyPair(%s)", new Object[]{keyPair});
        return keyPair;
    }
}

