/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNodeImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="ZooKeeper Node", description="Apache ZooKeeper is a server which enables highly reliable distributed coordination.")
@ImplementedBy(value=ZooKeeperNodeImpl.class)
public interface ZooKeeperNode
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"3.4.10");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"zookeeper-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://apache.org/dyn/closer.cgi?action=download&filename=zookeeper/zookeeper-${version}/zookeeper-${version}.tar.gz");
    @SetFromFlag(value="zookeeperPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"zookeeper.port", (String)"Zookeeper port", (Object)"2181+");
    @SetFromFlag(value="zookeeperLeaderPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_LEADER_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"zookeeper.leader.port", (String)"Zookeeper leader ports", (Object)"2888+");
    @SetFromFlag(value="zookeeperElectionPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_ELECTION_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"zookeeper.election.port", (String)"Zookeeper election ports", (Object)"3888+");
    @SetFromFlag(value="zookeeperConfig")
    public static final ConfigKey<String> ZOOKEEPER_CONFIG_TEMPLATE = ConfigKeys.newStringConfigKey((String)"zookeeper.configTemplate", (String)"Zookeeper configuration template (in freemarker format)", (String)"classpath://org/apache/brooklyn/entity/messaging/zookeeper/zoo.cfg");
    @SetFromFlag(value="zookeeperId")
    public static final BasicAttributeSensorAndConfigKey<Integer> MY_ID = new BasicAttributeSensorAndConfigKey(Integer.class, "zookeeper.myid", "ZooKeeper node's myId", (Object)1);
    public static final AttributeSensor<Long> OUTSTANDING_REQUESTS = Sensors.newLongSensor((String)"zookeeper.outstandingRequests", (String)"Outstanding request count");
    public static final AttributeSensor<Long> PACKETS_RECEIVED = Sensors.newLongSensor((String)"zookeeper.packets.received", (String)"Total packets received");
    public static final AttributeSensor<Long> PACKETS_SENT = Sensors.newLongSensor((String)"zookeeper.packets.sent", (String)"Total packets sent");
    public static final AttributeSensor<String> ZOOKEEPER_ENDPOINT = Sensors.newStringSensor((String)"zookeeper.endpoint", (String)"The host:port of the node");

    @Deprecated
    public Integer getZookeeperPort();

    @Deprecated
    public String getHostname();
}

