/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.zookeeper.WatchedEvent;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    public static boolean deleteFileRecursively(File file, boolean failOnError) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    File f = files[i];
                    boolean deleted = TestUtils.deleteFileRecursively(files[i], failOnError);
                    if (deleted || !failOnError) continue;
                    Assertions.fail((String)("file '" + f.getAbsolutePath() + "' deletion failed"));
                }
            }
            return file.delete();
        }
        return true;
    }

    public static boolean deleteFileRecursively(File file) {
        return TestUtils.deleteFileRecursively(file, false);
    }

    public static void assertWatchedEventEquals(WatchedEvent expected, WatchedEvent actual) {
        Assertions.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assertions.assertEquals((Object)expected.getPath(), (Object)actual.getPath());
        Assertions.assertEquals((long)expected.getZxid(), (long)actual.getZxid());
    }

    public static List<Thread> getAllThreads() {
        Thread[] threads;
        ThreadGroup threadGroup;
        for (threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null && threadGroup.getParent() != null; threadGroup = threadGroup.getParent()) {
        }
        int count = threadGroup.activeCount();
        while ((count = threadGroup.enumerate(threads = new Thread[count + count / 2 + 1], true)) >= threads.length) {
        }
        return Collections.unmodifiableList(Stream.of(threads).limit(count).collect(Collectors.toList()));
    }
}

