/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.perf.dlog.PerfReaderBase;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.api.namespace.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfReader
extends PerfReaderBase {
    private static final Logger log = LoggerFactory.getLogger(PerfReader.class);

    PerfReader(ServiceURI serviceURI, PerfReaderBase.Flags flags) {
        super(serviceURI, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(Namespace namespace) throws Exception {
        ArrayList<Pair> managers = new ArrayList<Pair>(this.flags.numLogs);
        for (int i = 0; i < this.flags.numLogs; ++i) {
            String logName = String.format(this.flags.logName, i);
            managers.add(Pair.of((Object)i, (Object)namespace.openLog(logName)));
        }
        log.info("Successfully open {} logs", (Object)managers.size());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.isDone.set(true);
            PerfReader.printAggregatedStats(this.cumulativeRecorder);
        }));
        ExecutorService executor = Executors.newFixedThreadPool(this.flags.numThreads);
        try {
            int i = 0;
            while (i < this.flags.numThreads) {
                int idx = i++;
                List logsThisThread = managers.stream().filter(pair -> (Integer)pair.getLeft() % this.flags.numThreads == idx).map(pair -> (DistributedLogManager)pair.getRight()).collect(Collectors.toList());
                executor.submit(() -> {
                    try {
                        this.read(logsThisThread);
                    }
                    catch (Exception e) {
                        log.error("Encountered error at writing records", (Throwable)e);
                    }
                });
            }
            log.info("Started {} write threads", (Object)this.flags.numThreads);
            this.reportStats();
        }
        finally {
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            managers.forEach(manager -> ((DistributedLogManager)manager.getRight()).asyncClose());
        }
    }

    void read(List<DistributedLogManager> logs) throws Exception {
        log.info("Read thread started with : logs = {}", logs.stream().map(l -> l.getStreamName()).collect(Collectors.toList()));
        List readers = logs.stream().map(manager -> {
            try {
                return manager.openLogReader(DLSN.InitialDLSN);
            }
            catch (IOException e) {
                log.error("Failed to open reader for log stream {}", (Object)manager.getStreamName(), (Object)e);
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
        int numLogs = logs.size();
        block0: while (true) {
            int i = 0;
            while (true) {
                if (i >= numLogs) continue block0;
                LogRecordWithDLSN record = ((LogReader)readers.get(i)).readNext(true);
                if (null != record) {
                    this.recordsRead.increment();
                    this.bytesRead.add(record.getPayloadBuf().readableBytes());
                }
                ++i;
            }
            break;
        }
    }
}

