/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.util.PortForwarder;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ObserverMasterTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FollowerRequestProcessorTest
extends ObserverMasterTestBase {
    private PortForwarder forwarder;

    @Test
    public void testFollowerRequestProcessorSkipsLearnerRequestToNextProcessor() throws Exception {
        this.setupTestObserverServer("true");
        this.zk.create("/testFollowerSkipNextAProcessor", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)"test", (Object)new String(this.zk.getData("/testFollowerSkipNextAProcessor", null, null)));
        Assertions.assertEquals((long)1L, (long)ServerMetrics.getMetrics().SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR_COUNT.get());
    }

    @Test
    public void testFollowerRequestProcessorSendsLearnerRequestToNextProcessor() throws Exception {
        this.setupTestObserverServer("false");
        this.zk.create("/testFollowerSkipNextAProcessor", "test".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((Object)"test", (Object)new String(this.zk.getData("/testFollowerSkipNextAProcessor", null, null)));
        Assertions.assertEquals((long)0L, (long)ServerMetrics.getMetrics().SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR_COUNT.get());
    }

    private void setupTestObserverServer(String skipLearnerRequestToNextProcessor) throws Exception {
        System.setProperty("zookeeper.follower.skipLearnerRequestToNextProcessor", skipLearnerRequestToNextProcessor);
        int OM_PROXY_PORT = PortAssignment.unique();
        this.forwarder = this.setUp(OM_PROXY_PORT, true);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 3 being up");
        this.zk = new ZooKeeper("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        FollowerRequestProcessorTest.waitForOne(this.zk, ZooKeeper.States.CONNECTED);
        ServerMetrics.getMetrics().resetAll();
    }

    @AfterEach
    public void cleanup() throws Exception {
        System.setProperty("zookeeper.follower.skipLearnerRequestToNextProcessor", "false");
        this.shutdown();
        if (this.forwarder != null) {
            this.forwarder.shutdown();
        }
    }
}

