/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.apache.aries.subsystem.core.internal.ThreadLocalSubsystem;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.SubsystemException;

public class BundleResourceUninstaller
extends ResourceUninstaller {
    public BundleResourceUninstaller(Resource resource, BasicSubsystem subsystem) {
        super(resource, subsystem);
    }

    @Override
    public void uninstall() {
        this.removeReference();
        BundleResourceUninstaller.removeConstituent(this.subsystem, (Resource)new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)this.resource));
        if (!this.isResourceUninstallable()) {
            return;
        }
        BundleResourceUninstaller.removeConstituent(this.provisionTo, (Resource)new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)this.resource));
        if (this.isBundleUninstallable()) {
            this.uninstallBundle();
        }
    }

    private Bundle getBundle() {
        return this.getBundleRevision().getBundle();
    }

    private BundleRevision getBundleRevision() {
        return (BundleRevision)this.resource;
    }

    private boolean isBundleUninstallable() {
        return this.getBundle().getState() != 1;
    }

    private void uninstallBundle() {
        ThreadLocalSubsystem.set(this.provisionTo);
        try {
            this.getBundle().uninstall();
        }
        catch (BundleException e) {
            throw new SubsystemException((Throwable)e);
        }
    }
}

