/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final ClassLoader FALLBACK_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private static final HashMap<String, Class> PRIM_CLASSES = new HashMap(8, 1.0f);
    private final ClassLoader inLoader;
    private static final InvocationHandler NOOP_HANDLER = (proxy, method, args) -> {
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return null;
        }
        if (returnType.isPrimitive()) {
            if (returnType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (returnType == Byte.TYPE) {
                return (byte)0;
            }
            if (returnType == Short.TYPE) {
                return (short)0;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (returnType == Double.TYPE) {
                return 0.0;
            }
            if (returnType == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
        }
        return null;
    };

    public ClassLoadingAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.inLoader = in.getClass().getClassLoader();
    }

    public ClassLoadingAwareObjectInputStream(ClassLoader classLoader, InputStream in) throws IOException {
        super(in);
        this.inLoader = classLoader != null ? classLoader : in.getClass().getClassLoader();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return this.load(classDesc.getName(), cl, this.inLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        try {
            return Proxy.newProxyInstance(cl, cinterfaces, NOOP_HANDLER).getClass();
        }
        catch (IllegalArgumentException e) {
            try {
                return Proxy.newProxyInstance(this.inLoader, cinterfaces, NOOP_HANDLER).getClass();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return Proxy.newProxyInstance(FALLBACK_CLASS_LOADER, cinterfaces, NOOP_HANDLER).getClass();
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new ClassNotFoundException(null, e);
                }
            }
        }
    }

    private Class<?> load(String className, ClassLoader ... cl) throws ClassNotFoundException {
        for (ClassLoader loader : cl) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        Class clazz = PRIM_CLASSES.get(className);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    static {
        PRIM_CLASSES.put("boolean", Boolean.TYPE);
        PRIM_CLASSES.put("byte", Byte.TYPE);
        PRIM_CLASSES.put("char", Character.TYPE);
        PRIM_CLASSES.put("short", Short.TYPE);
        PRIM_CLASSES.put("int", Integer.TYPE);
        PRIM_CLASSES.put("long", Long.TYPE);
        PRIM_CLASSES.put("float", Float.TYPE);
        PRIM_CLASSES.put("double", Double.TYPE);
        PRIM_CLASSES.put("void", Void.TYPE);
    }
}

