/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.tables;

import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.Validators;

public class TableNameUtil {
    private TableNameUtil() {
    }

    public static String qualified(String tableName) {
        return TableNameUtil.qualified(tableName, Namespace.DEFAULT.name());
    }

    public static String qualified(String tableName, String defaultNamespace) {
        Pair<String, String> qualifiedTableName = TableNameUtil.qualify(tableName, defaultNamespace);
        if (Namespace.DEFAULT.name().equals(qualifiedTableName.getFirst())) {
            return qualifiedTableName.getSecond();
        }
        return qualifiedTableName.toString("", ".", "");
    }

    public static Pair<String, String> qualify(String tableName) {
        return TableNameUtil.qualify(tableName, Namespace.DEFAULT.name());
    }

    private static Pair<String, String> qualify(String tableName, String defaultNamespace) {
        Validators.EXISTING_TABLE_NAME.validate(tableName);
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.", 2);
            return new Pair<String, String>(s[0], s[1]);
        }
        return new Pair<String, String>(defaultNamespace, tableName);
    }
}

