/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.FilePrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationTypeHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTypeHelper.class);
    private static final Map<String, Class<?>> loaded = Collections.synchronizedMap(new HashMap());

    public static long getFixedMemoryAsBytes(String str) {
        char lastChar = str.charAt(str.length() - 1);
        if (lastChar == 'b') {
            log.warn("The 'b' in {} is being considered as bytes. Setting memory by bits is not supported", (Object)str);
        }
        try {
            int multiplier;
            switch (Character.toUpperCase(lastChar)) {
                case 'G': {
                    multiplier = 30;
                    break;
                }
                case 'M': {
                    multiplier = 20;
                    break;
                }
                case 'K': {
                    multiplier = 10;
                    break;
                }
                case 'B': {
                    multiplier = 0;
                    break;
                }
                default: {
                    return Long.parseLong(str);
                }
            }
            return Long.parseLong(str.substring(0, str.length() - 1)) << multiplier;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The value '" + str + "' is not a valid memory setting. A valid value would a number possibly followed by an optional 'G', 'M', 'K', or 'B'.");
        }
    }

    public static long getMemoryAsBytes(String str) {
        char lastChar = str.charAt(str.length() - 1);
        if (lastChar == '%') {
            try {
                int percent = Integer.parseInt(str.substring(0, str.length() - 1));
                if (percent <= 0 || percent >= 100) {
                    throw new IllegalArgumentException("The value '" + str + "' is not a valid memory setting.");
                }
                return Runtime.getRuntime().maxMemory() * (long)percent / 100L;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("The value '" + str + "' is not a valid memory setting.");
            }
        }
        return ConfigurationTypeHelper.getFixedMemoryAsBytes(str);
    }

    public static long getTimeInMillis(String str) {
        TimeUnit timeUnit;
        int unitsLen = 1;
        switch (str.charAt(str.length() - 1)) {
            case 'd': {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            case 'h': {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 'm': {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 's': {
                timeUnit = TimeUnit.SECONDS;
                if (!str.endsWith("ms")) break;
                timeUnit = TimeUnit.MILLISECONDS;
                unitsLen = 2;
                break;
            }
            default: {
                timeUnit = TimeUnit.SECONDS;
                unitsLen = 0;
            }
        }
        return timeUnit.toMillis(Long.parseLong(str.substring(0, str.length() - unitsLen)));
    }

    public static double getFraction(String str) {
        if (!str.isEmpty() && str.charAt(str.length() - 1) == '%') {
            return Double.parseDouble(str.substring(0, str.length() - 1)) / 100.0;
        }
        return Double.parseDouble(str);
    }

    public static <T> T getClassInstance(String context, String clazzName, Class<T> base, T defaultInstance) {
        T instance = null;
        try {
            instance = ConfigurationTypeHelper.getClassInstance(context, clazzName, base);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            log.error("Failed to load class {} in classloader context {}", new Object[]{clazzName, context, e});
        }
        if (instance == null) {
            log.info("Using default class ({})", defaultInstance == null ? null : defaultInstance.getClass().getName());
            instance = defaultInstance;
        }
        return instance;
    }

    public static <T> T getClassInstance(String context, String clazzName, Class<T> base) throws ReflectiveOperationException {
        Class<T> clazz = ClassLoaderUtil.loadClass(context, clazzName, base);
        T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (loaded.put(clazzName, clazz) != clazz) {
            log.debug("Loaded class : {}", (Object)clazzName);
        }
        return instance;
    }

    public static int getNumThreads(String threads) {
        if (threads == null) {
            threads = ClientProperty.BULK_LOAD_THREADS.getDefaultValue();
        }
        int nThreads = threads.toUpperCase().endsWith("C") ? Runtime.getRuntime().availableProcessors() * Integer.parseInt(threads.substring(0, threads.length() - 1)) : Integer.parseInt(threads);
        return nThreads;
    }

    public static EnumSet<FilePrefix> getDropCacheBehindFilePrefixes(String propertyValue) {
        EnumSet<FilePrefix> filePrefixes;
        if (propertyValue.equalsIgnoreCase("ALL")) {
            filePrefixes = EnumSet.allOf(FilePrefix.class);
        } else if (propertyValue.equalsIgnoreCase("NON-IMPORT")) {
            filePrefixes = EnumSet.of(FilePrefix.FLUSH, FilePrefix.FULL_COMPACTION, FilePrefix.COMPACTION, FilePrefix.MERGING_MINOR_COMPACTION);
        } else if (propertyValue.equalsIgnoreCase("NONE")) {
            filePrefixes = EnumSet.noneOf(FilePrefix.class);
        } else {
            throw new IllegalArgumentException("Invalid value for property " + Property.TABLE_COMPACTION_INPUT_DROP_CACHE_BEHIND.getKey() + " expected one of ALL, NONE, or NON-IMPORT");
        }
        return filePrefixes;
    }
}

