/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TimedOutException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.SyncingTabletLocator;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.hadoop.io.Text;

public class TimeoutTabletLocator
extends SyncingTabletLocator {
    private final long timeout;
    private Long firstFailTime = null;

    private void failed() {
        if (this.firstFailTime == null) {
            this.firstFailTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.firstFailTime > this.timeout) {
            throw new TimedOutException("Failed to obtain metadata");
        }
    }

    private void succeeded() {
        this.firstFailTime = null;
    }

    public TimeoutTabletLocator(long timeout, ClientContext context, TableId table) {
        super(context, table);
        this.timeout = timeout;
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(ClientContext context, Text row, boolean skipRow, boolean retry) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            TabletLocator.TabletLocation ret = super.locateTablet(context, row, skipRow, retry);
            if (ret == null) {
                this.failed();
            } else {
                this.succeeded();
            }
            return ret;
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }

    @Override
    public <T extends Mutation> void binMutations(ClientContext context, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            super.binMutations(context, mutations, binnedMutations, failures);
            if (failures.size() == mutations.size()) {
                this.failed();
            } else {
                this.succeeded();
            }
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }

    @Override
    public List<Range> binRanges(ClientContext context, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        try {
            List<Range> ret = super.binRanges(context, ranges, binnedRanges);
            if (ranges.size() == ret.size()) {
                this.failed();
            } else {
                this.succeeded();
            }
            return ret;
        }
        catch (AccumuloException ae) {
            this.failed();
            throw ae;
        }
    }
}

