/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.securityImpl.thrift.TAuthenticationTokenIdentifier;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.ThriftMessageUtil;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;

public class AuthenticationTokenIdentifier
extends TokenIdentifier {
    public static final Text TOKEN_KIND = new Text("ACCUMULO_AUTH_TOKEN");
    private final TAuthenticationTokenIdentifier impl;

    public AuthenticationTokenIdentifier() {
        this.impl = new TAuthenticationTokenIdentifier();
        this.populateFields(this.impl);
    }

    public AuthenticationTokenIdentifier(TAuthenticationTokenIdentifier identifier) {
        Objects.requireNonNull(identifier);
        this.impl = new TAuthenticationTokenIdentifier(identifier);
        this.populateFields(identifier);
    }

    public void setKeyId(int keyId) {
        this.impl.setKeyId(keyId);
    }

    public int getKeyId() {
        return this.impl.getKeyId();
    }

    public void setIssueDate(long issueDate) {
        this.impl.setIssueDate(issueDate);
    }

    public long getIssueDate() {
        return this.impl.getIssueDate();
    }

    public void setExpirationDate(long expirationDate) {
        this.impl.setExpirationDate(expirationDate);
    }

    public long getExpirationDate() {
        return this.impl.getExpirationDate();
    }

    public void setInstanceId(InstanceId instanceId) {
        this.impl.setInstanceId(instanceId.canonical());
    }

    public InstanceId getInstanceId() {
        if (this.impl.getInstanceId() == null) {
            return InstanceId.of("");
        }
        return InstanceId.of(this.impl.getInstanceId());
    }

    public TAuthenticationTokenIdentifier getThriftIdentifier() {
        return this.impl;
    }

    public void write(DataOutput out) throws IOException {
        ThriftMessageUtil msgUtil = new ThriftMessageUtil();
        ByteBuffer serialized = msgUtil.serialize(this.impl);
        out.writeInt(serialized.limit());
        ByteBufferUtil.write(out, serialized);
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        if (length > 0) {
            ThriftMessageUtil msgUtil = new ThriftMessageUtil();
            byte[] serialized = new byte[length];
            in.readFully(serialized);
            TAuthenticationTokenIdentifier tAuthTokenId = msgUtil.deserialize(serialized, new TAuthenticationTokenIdentifier());
            this.populateFields(tAuthTokenId);
        }
    }

    private void populateFields(TAuthenticationTokenIdentifier tAuthTokenId) {
        this.impl.principal = tAuthTokenId.getPrincipal();
        this.setExpirationDate(tAuthTokenId.getExpirationDate());
        this.setIssueDate(tAuthTokenId.getIssueDate());
        if (tAuthTokenId.getInstanceId() != null) {
            this.setInstanceId(InstanceId.of(tAuthTokenId.getInstanceId()));
        }
        this.setKeyId(tAuthTokenId.getKeyId());
    }

    public Text getKind() {
        return TOKEN_KIND;
    }

    public UserGroupInformation getUser() {
        if (this.impl.isSetPrincipal()) {
            return UserGroupInformation.createRemoteUser((String)this.impl.getPrincipal());
        }
        return null;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(7, 11);
        if (this.impl.isSetPrincipal()) {
            hcb.append((Object)this.impl.getPrincipal());
        }
        if (this.impl.isSetKeyId()) {
            hcb.append(this.impl.getKeyId());
        }
        if (this.impl.isSetIssueDate()) {
            hcb.append(this.impl.getIssueDate());
        }
        if (this.impl.isSetExpirationDate()) {
            hcb.append(this.impl.getExpirationDate());
        }
        if (this.impl.isSetInstanceId()) {
            hcb.append((Object)this.impl.getInstanceId());
        }
        return hcb.toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("AuthenticationTokenIdentifier(").append(this.impl).append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AuthenticationTokenIdentifier) {
            AuthenticationTokenIdentifier other = (AuthenticationTokenIdentifier)((Object)o);
            return this.impl.equals(other.impl);
        }
        return false;
    }

    public static TAuthenticationTokenIdentifier createTAuthIdentifier(String principal, int keyId, long issueDate, long expirationDate, String instanceId) {
        TAuthenticationTokenIdentifier tIdentifier = new TAuthenticationTokenIdentifier(principal);
        tIdentifier.setKeyId(keyId);
        tIdentifier.setIssueDate(issueDate);
        tIdentifier.setExpirationDate(expirationDate);
        tIdentifier.setInstanceId(instanceId);
        return tIdentifier;
    }

    public boolean isSetIssueDate() {
        return this.impl.isSetIssueDate();
    }

    public boolean isSetExpirationDate() {
        return this.impl.isSetExpirationDate();
    }
}

