/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin.compaction;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.admin.compaction.CompactionConfigurer;
import org.apache.accumulo.core.client.admin.compaction.CompressionConfigurer;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;

public class ErasureCodeConfigurer
extends CompressionConfigurer {
    public static final String ERASURE_CODE_SIZE = "erasure.code.size.conversion";
    public static final String BYPASS_ERASURE_CODES = "erasure.code.bypass";
    public static final String ERASURE_CODE_POLICY = "erasure.code.policy";
    private String ecPolicyName = null;
    private Long ecSize;
    private Boolean byPassEC = false;

    @Override
    public void init(CompactionConfigurer.InitParameters iparams) {
        Map<String, String> options = iparams.getOptions();
        this.ecSize = ConfigurationTypeHelper.getFixedMemoryAsBytes(options.getOrDefault(ERASURE_CODE_SIZE, "0"));
        this.ecPolicyName = options.get(ERASURE_CODE_POLICY);
        this.byPassEC = Boolean.parseBoolean(options.getOrDefault(BYPASS_ERASURE_CODES, "false"));
        if (this.ecSize == 0L && !this.byPassEC.booleanValue()) {
            throw new IllegalArgumentException("Must set either erasure.code.size.conversion or erasure.code.bypass");
        }
        if (!this.byPassEC.booleanValue()) {
            Preconditions.checkArgument((this.ecSize > 0L ? 1 : 0) != 0, (Object)"Must set erasure.code.size.conversion to a positive integer");
        }
        super.init(iparams);
    }

    @Override
    public CompactionConfigurer.Overrides override(CompactionConfigurer.InputParameters params) {
        HashMap<String, String> overs = new HashMap<String, String>(super.override(params).getOverrides());
        if (this.byPassEC.booleanValue()) {
            overs.put(Property.TABLE_ENABLE_ERASURE_CODES.getKey(), "disable");
        } else {
            long inputsSum = params.getInputFiles().stream().mapToLong(CompactableFile::getEstimatedSize).sum();
            if (inputsSum >= this.ecSize) {
                overs.put(Property.TABLE_ENABLE_ERASURE_CODES.getKey(), "enable");
                if (this.ecPolicyName != null) {
                    overs.put(Property.TABLE_ERASURE_CODE_POLICY.getKey(), this.ecPolicyName);
                }
            } else {
                overs.put(Property.TABLE_ENABLE_ERASURE_CODES.getKey(), "disable");
            }
        }
        return new CompactionConfigurer.Overrides(overs);
    }
}

