/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellExtension;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ExtensionCommand
extends Shell.Command {
    protected Option enable;
    protected Option disable;
    protected Option list;
    private ServiceLoader<ShellExtension> extensions = null;
    private Set<String> loadedHeaders = new HashSet<String>();
    private Set<String> loadedCommands = new HashSet<String>();
    private Set<String> loadedExtensions = new TreeSet<String>();

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        if (cl.hasOption(this.enable.getOpt())) {
            this.extensions = ServiceLoader.load(ShellExtension.class);
            for (ShellExtension se : this.extensions) {
                this.loadedExtensions.add(se.getExtensionName());
                String header = "-- " + se.getExtensionName() + " Extension Commands ---------";
                this.loadedHeaders.add(header);
                shellState.commandGrouping.put(header, se.getCommands());
                for (Shell.Command cmd : se.getCommands()) {
                    String name = se.getExtensionName() + "::" + cmd.getName();
                    this.loadedCommands.add(name);
                    shellState.commandFactory.put(name, cmd);
                }
            }
        } else if (cl.hasOption(this.disable.getOpt())) {
            for (String header : this.loadedHeaders) {
                shellState.commandGrouping.remove(header);
            }
            for (String name : this.loadedCommands) {
                shellState.commandFactory.remove(name);
            }
            this.loadedExtensions.clear();
            this.extensions.reload();
        } else if (cl.hasOption(this.list.getOpt())) {
            shellState.printLines(this.loadedExtensions.iterator(), true);
        } else {
            this.printHelp(shellState);
        }
        return 0;
    }

    @Override
    public String description() {
        return "Enable, disable, or list shell extensions";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public String getName() {
        return "extensions";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.enable = new Option("e", "enable", false, "enable shell extensions");
        this.disable = new Option("d", "disable", false, "disable shell extensions");
        this.list = new Option("l", "list", false, "list shell extensions");
        o.addOption(this.enable);
        o.addOption(this.disable);
        o.addOption(this.list);
        return o;
    }
}

