/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.hadoop.security.UserGroupInformation;

public class ClusterUser {
    private String password;
    private String principal;
    private File keytab;

    public ClusterUser(String principal, File keytab) {
        Objects.requireNonNull(principal, "Principal was null");
        Objects.requireNonNull(keytab, "Keytab was null");
        Preconditions.checkArgument((keytab.exists() && keytab.isFile() ? 1 : 0) != 0, (Object)"Keytab should be a file");
        this.principal = principal;
        this.keytab = keytab;
    }

    public ClusterUser(String principal, String password) {
        Objects.requireNonNull(principal, "Principal was null");
        Objects.requireNonNull(password, "Password was null");
        this.principal = principal;
        this.password = password;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public File getKeytab() {
        return this.keytab;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationToken getToken() throws IOException {
        if (this.password != null) {
            return new PasswordToken((CharSequence)this.password);
        }
        if (this.keytab != null) {
            UserGroupInformation.loginUserFromKeytab((String)this.principal, (String)this.keytab.getAbsolutePath());
            return new KerberosToken();
        }
        throw new IllegalStateException("One of password and keytab must be non-null");
    }

    public String toString() {
        return "KerberosPrincipal [principal=" + this.principal + ", keytab=" + String.valueOf(this.keytab) + ", password=" + this.password + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.principal.hashCode();
        result = 31 * result + (this.keytab == null ? 0 : this.keytab.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClusterUser) {
            ClusterUser other = (ClusterUser)obj;
            if (this.keytab == null ? other.keytab != null : !this.keytab.equals(other.keytab)) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            return this.principal.equals(other.principal);
        }
        return false;
    }
}

